<?php $title = 'View Shared Credential'; ?>

<h1>Shared Credential</h1>

<div class="alert alert-info">
    Shared by <strong><?php echo htmlspecialchars(($owner['username'] ?? 'Unknown') . ' (' . ($owner['email'] ?? '') . ')'); ?></strong>
    on <?php echo htmlspecialchars(date('Y-m-d H:i', strtotime($share['shared_at']))); ?>
</div>

<div class="panel">
    <table>
        <?php if (!empty($credential['title'])): ?>
        <tr>
            <td style="width:150px;"><strong>Title:</strong></td>
            <td><?php echo htmlspecialchars($credential['title']); ?></td>
        </tr>
        <?php endif; ?>

        <?php if (!empty($credential['type'])): ?>
        <tr>
            <td><strong>Type:</strong></td>
            <td><?php echo htmlspecialchars($credential['type']); ?></td>
        </tr>
        <?php endif; ?>

        <?php if (!empty($credential['username'])): ?>
        <tr>
            <td><strong>Username:</strong></td>
            <td style="display:flex; align-items:center; gap:10px;">
                <code style="flex:1;"><?php echo htmlspecialchars($credential['username']); ?></code>
                <button class="button" onclick="copyToClipboard('<?php echo htmlspecialchars($credential['username'], ENT_QUOTES); ?>')">Copy</button>
            </td>
        </tr>
        <?php endif; ?>

        <?php if (!empty($credential['password'])): ?>
        <tr>
            <td><strong>Password:</strong></td>
            <td style="display:flex; align-items:center; gap:10px;">
                <code id="sv-pw-field" style="flex:1;">••••••••</code>
                <button class="button" id="sv-pw-btn" onclick="toggleSharedPassword()">Show</button>
                <button class="button" onclick="copyToClipboard('<?php echo htmlspecialchars($credential['password'], ENT_QUOTES); ?>')">Copy</button>
                <input type="hidden" id="sv-pw-value" value="<?php echo htmlspecialchars($credential['password']); ?>">
            </td>
        </tr>
        <?php endif; ?>

        <?php if (!empty($credential['url'])): ?>
        <tr>
            <td><strong>URL:</strong></td>
            <td style="display:flex; align-items:center; gap:10px;">
                <a href="<?php echo htmlspecialchars($credential['url']); ?>" target="_blank" style="flex:1; overflow:hidden; text-overflow:ellipsis;">
                    <?php echo htmlspecialchars($credential['url']); ?>
                </a>
                <button class="button" onclick="copyToClipboard('<?php echo htmlspecialchars($credential['url'], ENT_QUOTES); ?>')">Copy</button>
            </td>
        </tr>
        <?php endif; ?>

        <?php if (!empty($credential['notes'])): ?>
        <tr>
            <td><strong>Notes:</strong></td>
            <td><?php echo nl2br(htmlspecialchars($credential['notes'])); ?></td>
        </tr>
        <?php endif; ?>

        <?php if (!empty($credential['tags'])): ?>
        <tr>
            <td><strong>Tags:</strong></td>
            <td><?php echo htmlspecialchars(implode(', ', (array)$credential['tags'])); ?></td>
        </tr>
        <?php endif; ?>

        <?php if (!empty($credential['folder'])): ?>
        <tr>
            <td><strong>Folder:</strong></td>
            <td><?php echo htmlspecialchars($credential['folder']); ?></td>
        </tr>
        <?php endif; ?>
    </table>
</div>

<?php
$perms = [];
if (!empty($share['permissions']['can_edit']))    $perms[] = 'Edit';
if (!empty($share['permissions']['can_reshare'])) $perms[] = 'Reshare';
if ($perms):
?>
<div class="alert alert-info">
    Permissions granted: View, <?php echo implode(', ', $perms); ?>
</div>
<?php endif; ?>

<p>
    <a href="/index.php?page=shares" class="button">Back to Shares</a>
</p>

<script>
function toggleSharedPassword() {
    var field = document.getElementById('sv-pw-field');
    var btn   = document.getElementById('sv-pw-btn');
    var val   = document.getElementById('sv-pw-value').value;
    if (field.textContent === '••••••••') {
        field.textContent = val;
        btn.textContent   = 'Hide';
    } else {
        field.textContent = '••••••••';
        btn.textContent   = 'Show';
    }
}
</script>
