<?php $title = 'Shared Credentials'; ?>

<h1>Shared Credentials</h1>

<?php if (isset($success) && $success): ?>
    <div class="alert alert-success">
        <?php echo htmlspecialchars($success); ?>
    </div>
<?php endif; ?>

<?php if (isset($error) && $error): ?>
    <div class="alert alert-error">
        <?php echo htmlspecialchars($error); ?>
    </div>
<?php endif; ?>

<h2>Credentials Shared With Me</h2>
<?php if (!empty($shared_with_me)): ?>
    <div class="alert alert-info">
        These credentials have been shared with you. Click "View" to open them.
    </div>

    <table>
        <thead>
            <tr>
                <th>Credential</th>
                <th>Shared By</th>
                <th>Shared Date</th>
                <th>Permissions</th>
                <th>Status</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($shared_with_me as $share): ?>
                <tr>
                    <td><?php echo htmlspecialchars(substr($share['credential_id'], 0, 8) . '…'); ?></td>
                    <td><?php echo htmlspecialchars($user_map[$share['owner_id']] ?? $share['owner_id']); ?></td>
                    <td><?php echo htmlspecialchars(date('Y-m-d', strtotime($share['shared_at']))); ?></td>
                    <td>
                        <?php
                        $perms = ['View'];
                        if (!empty($share['permissions']['can_edit']))    $perms[] = 'Edit';
                        if (!empty($share['permissions']['can_reshare'])) $perms[] = 'Reshare';
                        echo implode(', ', $perms);
                        ?>
                    </td>
                    <td><?php echo $share['revoked'] ? '<span style="color:red;">Revoked</span>' : '<span style="color:green;">Active</span>'; ?></td>
                    <td>
                        <?php if (!$share['revoked']): ?>
                            <a href="/index.php?page=shares&action=view&id=<?php echo urlencode($share['id']); ?>" class="button">View</a>
                        <?php endif; ?>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
<?php else: ?>
    <div class="alert alert-info">
        No credentials have been shared with you yet.
    </div>
<?php endif; ?>

<h2>Credentials I've Shared</h2>
<?php if (!empty($my_shares)): ?>
    <table>
        <thead>
            <tr>
                <th>Credential</th>
                <th>Shared With</th>
                <th>Shared Date</th>
                <th>Permissions</th>
                <th>Status</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($my_shares as $share): ?>
                <tr>
                    <td><?php echo htmlspecialchars(substr($share['credential_id'], 0, 8) . '…'); ?></td>
                    <td><?php echo htmlspecialchars($user_map[$share['shared_with_user_id']] ?? $share['shared_with_user_id']); ?></td>
                    <td><?php echo htmlspecialchars(date('Y-m-d', strtotime($share['shared_at']))); ?></td>
                    <td>
                        <?php
                        $perms = ['View'];
                        if (!empty($share['permissions']['can_edit']))    $perms[] = 'Edit';
                        if (!empty($share['permissions']['can_reshare'])) $perms[] = 'Reshare';
                        echo implode(', ', $perms);
                        ?>
                    </td>
                    <td><?php echo $share['revoked'] ? '<span style="color:red;">Revoked</span>' : '<span style="color:green;">Active</span>'; ?></td>
                    <td>
                        <?php if (!$share['revoked']): ?>
                            <form method="POST" action="/index.php?page=shares&action=revoke" style="display:inline;">
                                <input type="hidden" name="csrf_token"    value="<?php echo htmlspecialchars($csrf_token ?? ''); ?>">
                                <input type="hidden" name="share_id"      value="<?php echo htmlspecialchars($share['id']); ?>">
                                <button type="submit" class="button" onclick="return confirm('Revoke this share?')">Revoke</button>
                            </form>
                        <?php endif; ?>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
<?php else: ?>
    <div class="alert alert-info">
        You haven't shared any credentials yet. Open a credential and use <strong>Share with User</strong> to get started.
    </div>
<?php endif; ?>
