<?php $title = 'Shared Credential'; ?>

<h1>Shared Credential</h1>

<div class="alert alert-warning no-auto-hide">
    <strong>One-time link</strong> — This link has now been consumed and cannot be opened again.
    Save any information you need before leaving this page.
</div>

<div class="panel">
    <table>
        <?php if (!empty($credential['title'])): ?>
        <tr>
            <td style="width:150px;"><strong>Title:</strong></td>
            <td><?php echo htmlspecialchars($credential['title']); ?></td>
        </tr>
        <?php endif; ?>

        <?php if (!empty($credential['type'])): ?>
        <tr>
            <td><strong>Type:</strong></td>
            <td><?php echo htmlspecialchars($credential['type']); ?></td>
        </tr>
        <?php endif; ?>

        <?php if (!empty($credential['username'])): ?>
        <tr>
            <td><strong>Username:</strong></td>
            <td style="display:flex; align-items:center; gap:10px;">
                <code style="flex:1;"><?php echo htmlspecialchars($credential['username']); ?></code>
                <button class="button" onclick="copyToClipboard('<?php echo htmlspecialchars($credential['username'], ENT_QUOTES); ?>')">Copy</button>
            </td>
        </tr>
        <?php endif; ?>

        <?php if (!empty($credential['password'])): ?>
        <tr>
            <td><strong>Password:</strong></td>
            <td style="display:flex; align-items:center; gap:10px;">
                <code id="ps-pw-field" style="flex:1; letter-spacing:2px;">••••••••</code>
                <button class="button" id="ps-pw-btn" onclick="revealPassword()">Reveal Password</button>
                <button class="button" id="ps-copy-btn" style="display:none;" onclick="copyToClipboard(document.getElementById('ps-pw-value').value)">Copy</button>
                <input type="hidden" id="ps-pw-value" value="<?php echo htmlspecialchars($credential['password']); ?>">
            </td>
        </tr>
        <?php endif; ?>

        <?php if (!empty($credential['url'])): ?>
        <tr>
            <td><strong>URL:</strong></td>
            <td style="display:flex; align-items:center; gap:10px;">
                <a href="<?php echo htmlspecialchars($credential['url']); ?>" target="_blank" rel="noopener noreferrer" style="flex:1; overflow:hidden; text-overflow:ellipsis;">
                    <?php echo htmlspecialchars($credential['url']); ?>
                </a>
                <button class="button" onclick="copyToClipboard('<?php echo htmlspecialchars($credential['url'], ENT_QUOTES); ?>')">Copy</button>
            </td>
        </tr>
        <?php endif; ?>

        <?php if (!empty($credential['notes'])): ?>
        <tr>
            <td><strong>Notes:</strong></td>
            <td><?php echo nl2br(htmlspecialchars($credential['notes'])); ?></td>
        </tr>
        <?php endif; ?>

        <?php if (!empty($credential['tags'])): ?>
        <tr>
            <td><strong>Tags:</strong></td>
            <td><?php echo htmlspecialchars(implode(', ', (array)$credential['tags'])); ?></td>
        </tr>
        <?php endif; ?>
    </table>
</div>

<div class="alert alert-info">
    Link generated on <?php echo htmlspecialchars(date('Y-m-d H:i', strtotime($share['created_at']))); ?>.
</div>

<script>
function revealPassword() {
    var field = document.getElementById('ps-pw-field');
    var btn   = document.getElementById('ps-pw-btn');
    var copy  = document.getElementById('ps-copy-btn');
    var val   = document.getElementById('ps-pw-value').value;
    field.textContent  = val;
    field.style.letterSpacing = 'normal';
    btn.style.display  = 'none';
    copy.style.display = '';
}
</script>
