<?php $title = 'Public Share Links'; ?>

<h1>Public Share Links</h1>

<?php if (isset($success) && $success): ?>
    <div class="alert alert-success"><?php echo htmlspecialchars($success); ?></div>
<?php endif; ?>

<?php if (isset($error) && $error): ?>
    <div class="alert alert-error"><?php echo htmlspecialchars($error); ?></div>
<?php endif; ?>

<div class="alert alert-info no-auto-hide">
    Public share links are <strong>one-time use</strong>. Once someone opens the link, it expires permanently
    and the credential data can no longer be accessed via that link.
</div>

<?php if (!empty($shares)): ?>
    <table>
        <thead>
            <tr>
                <th>Credential</th>
                <th>Created</th>
                <th>Status</th>
                <th>Link</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($shares as $share): ?>
                <tr>
                    <td><?php echo htmlspecialchars($share['credential_data']['title'] ?? substr($share['credential_id'], 0, 8) . '…'); ?></td>
                    <td><?php echo htmlspecialchars(date('Y-m-d H:i', strtotime($share['created_at']))); ?></td>
                    <td>
                        <?php if ($share['viewed']): ?>
                            <span style="color:red;">Used <?php echo htmlspecialchars(date('Y-m-d H:i', strtotime($share['viewed_at']))); ?></span>
                        <?php else: ?>
                            <span style="color:green;">Active</span>
                        <?php endif; ?>
                    </td>
                    <td style="max-width:320px; overflow:hidden;">
                        <?php if (!$share['viewed']): ?>
                            <code style="font-size:10px; word-break:break-all; display:block;">
                                <?php echo htmlspecialchars($base_url . '/index.php?page=public-share&token=' . $share['token']); ?>
                            </code>
                            <button class="button" style="margin-top:4px;" onclick="copyToClipboard('<?php echo htmlspecialchars($base_url . '/index.php?page=public-share&token=' . $share['token'], ENT_QUOTES); ?>')">Copy Link</button>
                        <?php else: ?>
                            <em style="color:#888;">Expired</em>
                        <?php endif; ?>
                    </td>
                    <td>
                        <form method="POST" action="/index.php?page=public-share&action=revoke" style="display:inline;">
                            <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($csrf_token); ?>">
                            <input type="hidden" name="token" value="<?php echo htmlspecialchars($share['token']); ?>">
                            <button type="submit" class="button" onclick="return confirm('Delete this public link record?')">Delete</button>
                        </form>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
<?php else: ?>
    <div class="alert alert-info">
        You have no public share links. Open a credential and click <strong>Create Public Link</strong> to generate one.
    </div>
<?php endif; ?>

<p><a href="/index.php?page=credentials" class="button">Back to Credentials</a></p>
