<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>PassGram v3.0 - Public PGP Key Directory</title>
    <link rel="stylesheet" href="/assets/css/style.css">
</head>
<body>
    <div class="window window-large">
        <div class="title-bar">
            <span class="title-bar-text">PassGram v3.0 - Public PGP Key Directory</span>
            <div class="title-bar-controls">
                <span class="title-bar-button">_</span>
                <span class="title-bar-button">&#9633;</span>
                <span class="title-bar-button">X</span>
            </div>
        </div>
        <div class="window-body">

            <div class="flex-between" style="margin-bottom: 20px;">
                <h1>Public PGP Key Directory</h1>
                <a href="/login.php" class="button">Login</a>
            </div>

            <div class="alert alert-info">
                These public keys have been voluntarily listed by their owners.
                Search by name, email, label, or fingerprint. Click "Copy Key" to
                copy the full PGP public key text to your clipboard.
            </div>

            <div class="form-group" style="margin-bottom: 15px;">
                <label for="key-search">Search:</label>
                <input type="text" id="key-search"
                       placeholder="Filter by name, email, label or fingerprint..."
                       oninput="filterKeys(this.value)">
            </div>

            <?php if (!empty($keys)): ?>
                <p id="key-count" style="margin-bottom: 8px; font-size: 11px; color: #666;">
                    <?php echo count($keys); ?> key(s) listed
                </p>

                <table id="keys-table">
                    <thead>
                        <tr>
                            <th>Label</th>
                            <th>Owner</th>
                            <th>Email</th>
                            <th>Algorithm</th>
                            <th>Fingerprint</th>
                            <th>Updated</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php foreach ($keys as $k): ?>
                        <tr class="key-row"
                            data-search="<?php echo htmlspecialchars(
                                strtolower(
                                    ($k['label'] ?? '') . ' ' .
                                    ($k['owner_name'] ?? '') . ' ' .
                                    ($k['owner_email'] ?? '') . ' ' .
                                    ($k['fingerprint'] ?? '')
                                )
                            ); ?>">
                            <td><strong><?php echo htmlspecialchars($k['label']); ?></strong></td>
                            <td><?php echo htmlspecialchars($k['owner_name'] ?? ''); ?></td>
                            <td><?php echo htmlspecialchars($k['owner_email'] ?? ''); ?></td>
                            <td><?php echo htmlspecialchars(($k['algorithm'] ?? '') . ' ' . ($k['key_bits'] ?? '') . ' bits'); ?></td>
                            <td>
                                <code style="font-size: 10px; word-break: break-all;">
                                    <?php echo htmlspecialchars(substr($k['fingerprint'] ?? '', 0, 16) . '...'); ?>
                                </code>
                            </td>
                            <td><?php echo htmlspecialchars(date('Y-m-d', strtotime($k['updated_at']))); ?></td>
                            <td>
                                <button class="button"
                                        onclick="copyPGPKey(this)"
                                        data-key="<?php echo htmlspecialchars($k['public_key'], ENT_QUOTES); ?>">
                                    Copy Key
                                </button>
                                <button class="button"
                                        onclick="copyFingerprint('<?php echo htmlspecialchars($k['fingerprint'], ENT_QUOTES); ?>')">
                                    Copy FP
                                </button>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>

            <?php else: ?>
                <div class="alert alert-info">
                    No public PGP keys have been listed yet.
                </div>
            <?php endif; ?>

            <hr style="margin-top: 20px;">
            <p style="font-size: 11px; color: #666; text-align: center;">
                <a href="/login.php">Login to PassGram</a> to manage your own PGP keys.
            </p>

        </div>
    </div>

    <script>
    function filterKeys(query) {
        var term  = query.toLowerCase().trim();
        var rows  = document.querySelectorAll('#keys-table tbody .key-row');
        var shown = 0;

        rows.forEach(function(row) {
            var haystack = row.getAttribute('data-search') || '';
            var visible  = (term === '' || haystack.indexOf(term) !== -1);
            row.style.display = visible ? '' : 'none';
            if (visible) shown++;
        });

        var countEl = document.getElementById('key-count');
        if (countEl) {
            countEl.textContent = shown + ' key(s) listed';
        }
    }

    function copyPGPKey(btn) {
        var keyText = btn.getAttribute('data-key');
        copyTextToClipboard(keyText, 'Public key copied to clipboard!');
    }

    function copyFingerprint(fp) {
        copyTextToClipboard(fp, 'Fingerprint copied to clipboard!');
    }

    function copyTextToClipboard(text, message) {
        if (navigator.clipboard && navigator.clipboard.writeText) {
            navigator.clipboard.writeText(text).then(function() {
                showCopyNotification(message);
            }).catch(function() {
                fallbackCopy(text, message);
            });
        } else {
            fallbackCopy(text, message);
        }
    }

    function fallbackCopy(text, message) {
        var textarea = document.createElement('textarea');
        textarea.value = text;
        textarea.style.position = 'fixed';
        textarea.style.opacity = '0';
        document.body.appendChild(textarea);
        textarea.select();
        document.execCommand('copy');
        document.body.removeChild(textarea);
        showCopyNotification(message);
    }

    function showCopyNotification(message) {
        var existing = document.getElementById('copy-notification');
        if (existing) existing.remove();

        var div = document.createElement('div');
        div.id = 'copy-notification';
        div.textContent = message;
        div.style.cssText = 'position:fixed;top:20px;right:20px;background:#008000;color:#fff;padding:8px 16px;font-family:monospace;font-size:12px;z-index:9999;border:2px outset #ccc;';
        document.body.appendChild(div);
        setTimeout(function() { div.remove(); }, 2000);
    }
    </script>
</body>
</html>
