<?php $title = 'View PGP Key'; ?>

<?php if (isset($success) && $success): ?>
    <div class="alert alert-success">
        <?php echo htmlspecialchars($success); ?>
    </div>
<?php endif; ?>

<?php if (isset($error) && $error): ?>
    <div class="alert alert-error">
        <?php echo htmlspecialchars($error); ?>
    </div>
<?php endif; ?>

<div class="flex-between" style="margin-bottom: 20px;">
    <h1>
        <?php echo htmlspecialchars($key['label'] ?? 'PGP Key'); ?>
        <?php if (isset($is_owner) && !$is_owner): ?>
            <small style="color: #666; font-size: 14px;">(Shared via group)</small>
        <?php endif; ?>
    </h1>
    <div>
        <?php if (!isset($is_owner) || $is_owner): ?>
            <a href="/index.php?page=pgpkeys&action=edit&id=<?php echo urlencode($key['id']); ?>" class="button">Edit</a>
        <?php endif; ?>
        <a href="/index.php?page=pgpkeys" class="button">Back to Key Store</a>
    </div>
</div>

<div class="panel">
    <h2>Key Information</h2>
    <table>
        <tr>
            <td style="width: 150px;"><strong>Label:</strong></td>
            <td><?php echo htmlspecialchars($key['label']); ?></td>
        </tr>
        <?php if (!empty($key['owner_name'])): ?>
        <tr>
            <td><strong>Owner:</strong></td>
            <td><?php echo htmlspecialchars($key['owner_name']); ?></td>
        </tr>
        <?php endif; ?>
        <?php if (!empty($key['owner_email'])): ?>
        <tr>
            <td><strong>Email:</strong></td>
            <td><?php echo htmlspecialchars($key['owner_email']); ?></td>
        </tr>
        <?php endif; ?>
        <tr>
            <td><strong>Algorithm:</strong></td>
            <td><?php echo htmlspecialchars($key['algorithm'] . ' ' . $key['key_bits'] . ' bits'); ?></td>
        </tr>
        <tr>
            <td><strong>Fingerprint:</strong></td>
            <td style="display: flex; align-items: center; gap: 10px;">
                <code style="flex: 1; font-size: 10px; word-break: break-all;"><?php echo htmlspecialchars($key['fingerprint']); ?></code>
                <button class="button" onclick="copyToClipboard('<?php echo htmlspecialchars($key['fingerprint'], ENT_QUOTES); ?>')">Copy</button>
            </td>
        </tr>
        <?php if (!empty($key['tags'])): ?>
        <tr>
            <td><strong>Tags:</strong></td>
            <td><?php echo htmlspecialchars(implode(', ', $key['tags'])); ?></td>
        </tr>
        <?php endif; ?>
        <tr>
            <td><strong>Stored:</strong></td>
            <td><?php echo htmlspecialchars(date('Y-m-d H:i:s', strtotime($key['created_at']))); ?></td>
        </tr>
        <tr>
            <td><strong>Last Updated:</strong></td>
            <td><?php echo htmlspecialchars(date('Y-m-d H:i:s', strtotime($key['updated_at']))); ?></td>
        </tr>
        <?php if (!isset($is_owner) || $is_owner): ?>
        <tr>
            <td><strong>Public Listing:</strong></td>
            <td>
                <?php if (!empty($key['is_public'])): ?>
                    <span style="color: #008000; font-weight: bold;">Listed in public directory</span>
                <?php else: ?>
                    <span style="color: #808080;">Private (not publicly listed)</span>
                <?php endif; ?>
            </td>
        </tr>
        <?php endif; ?>
    </table>
</div>

<?php if (!empty($key['notes'])): ?>
    <h2>Notes</h2>
    <div class="panel">
        <?php echo nl2br(htmlspecialchars($key['notes'])); ?>
    </div>
<?php endif; ?>

<h2>Public Key</h2>
<div class="panel">
    <textarea id="pgp-public-key" readonly rows="12" style="width: 100%; font-family: 'Courier New', monospace; font-size: 11px;"><?php echo htmlspecialchars($key['public_key']); ?></textarea>
</div>

<div class="form-group">
    <button class="button" onclick="copyPublicKey()">Copy Public Key</button>
    <button class="button" onclick="downloadPublicKey()">Download Public Key</button>
</div>

<script>
function copyPublicKey() {
    var textarea = document.getElementById('pgp-public-key');
    textarea.select();
    document.execCommand('copy');
    showNotification('Public key copied to clipboard!', 'success');
}

function downloadPublicKey() {
    var publicKey = document.getElementById('pgp-public-key').value;
    var label = '<?php echo htmlspecialchars($key['label'], ENT_QUOTES); ?>';
    var blob = new Blob([publicKey], { type: 'text/plain' });
    var url = window.URL.createObjectURL(blob);
    var a = document.createElement('a');
    a.href = url;
    a.download = label.replace(/[^a-zA-Z0-9]/g, '_') + '_public.pem';
    document.body.appendChild(a);
    a.click();
    document.body.removeChild(a);
    window.URL.revokeObjectURL(url);
    showNotification('Public key downloaded!', 'success');
}
</script>

<?php if (!isset($is_owner) || $is_owner): ?>
<h2 id="sharing">Group Sharing</h2>

<?php if (!empty($user_groups)): ?>
    <div class="panel">
        <h3>Share with Group</h3>
        <form method="POST" action="/index.php?page=pgpkeys&action=share-with-group">
            <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($csrf_token ?? ''); ?>">
            <input type="hidden" name="key_id" value="<?php echo htmlspecialchars($key['id']); ?>">

            <div class="form-group">
                <label for="group_id">Select Group:</label>
                <select id="group_id" name="group_id" required>
                    <option value="">-- Choose a Group --</option>
                    <?php foreach ($user_groups as $group): ?>
                        <option value="<?php echo htmlspecialchars($group['id']); ?>">
                            <?php echo htmlspecialchars($group['name']); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>

            <button type="submit" class="button">Share with Group</button>
        </form>
    </div>

    <?php if (!empty($key['shared_with_groups'])): ?>
        <div class="panel" style="margin-top: 20px;">
            <h3>Currently Shared With</h3>
            <table>
                <thead>
                    <tr>
                        <th>Group</th>
                        <th>Shared On</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($key['shared_with_groups'] as $groupShare): ?>
                        <?php
                        $groupName = 'Unknown Group';
                        foreach ($user_groups as $group) {
                            if ($group['id'] === $groupShare['group_id']) {
                                $groupName = $group['name'];
                                break;
                            }
                        }
                        ?>
                        <tr>
                            <td><?php echo htmlspecialchars($groupName); ?></td>
                            <td><?php echo htmlspecialchars(date('Y-m-d H:i', strtotime($groupShare['shared_at']))); ?></td>
                            <td>
                                <form method="POST" action="/index.php?page=pgpkeys&action=revoke-group-share" style="display: inline;">
                                    <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($csrf_token ?? ''); ?>">
                                    <input type="hidden" name="key_id" value="<?php echo htmlspecialchars($key['id']); ?>">
                                    <input type="hidden" name="group_id" value="<?php echo htmlspecialchars($groupShare['group_id']); ?>">
                                    <button type="submit" class="button" onclick="return confirm('Revoke group access?')">Revoke</button>
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    <?php endif; ?>
<?php else: ?>
    <div class="alert alert-info">
        You are not a member of any groups. Join or create a group to share PGP keys with teams.
    </div>
<?php endif; ?>

<hr>

<h2>Delete Key</h2>
<form method="POST" action="/index.php?page=pgpkeys&action=delete" onsubmit="return confirm('Are you sure you want to delete this PGP key? This cannot be undone.');">
    <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($csrf_token ?? ''); ?>">
    <input type="hidden" name="id" value="<?php echo htmlspecialchars($key['id']); ?>">
    <button type="submit" class="button" style="background: #ff0000; color: #fff;">Delete PGP Key</button>
</form>
<?php endif; ?>
