<?php $title = 'PGP Key Store'; ?>

<div class="flex-between" style="margin-bottom: 20px;">
    <h1>PGP Key Store</h1>
    <a href="/index.php?page=pgpkeys&action=create" class="button">Import Key</a>
</div>

<?php if (isset($success) && $success): ?>
    <div class="alert alert-success">
        <?php echo htmlspecialchars($success); ?>
    </div>
<?php endif; ?>

<?php if (isset($error) && $error): ?>
    <div class="alert alert-error">
        <?php echo htmlspecialchars($error); ?>
    </div>
<?php endif; ?>

<div class="alert alert-info" style="margin-bottom: 15px;">
    Store and organize public PGP keys. Share them with your groups so team members can access keys they need for encrypted communication.
</div>

<?php if (!empty($keys)): ?>
    <table>
        <thead>
            <tr>
                <th>Label</th>
                <th>Owner</th>
                <th>Algorithm</th>
                <th>Fingerprint</th>
                <th>Access</th>
                <th>Updated</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($keys as $k): ?>
                <tr>
                    <td>
                        <strong><?php echo htmlspecialchars($k['label']); ?></strong>
                        <?php if (isset($k['is_owner']) && !$k['is_owner']): ?>
                            <br><small style="color: #666;">(Shared via group)</small>
                        <?php endif; ?>
                        <?php if (isset($k['is_owner']) && $k['is_owner'] && !empty($k['shared_group_names'])): ?>
                            <br><small style="color: #666; font-size: 10px;">
                                Shared with: <?php echo htmlspecialchars(implode(', ', $k['shared_group_names'])); ?>
                            </small>
                        <?php endif; ?>
                    </td>
                    <td>
                        <?php if (!empty($k['owner_name'])): ?>
                            <?php echo htmlspecialchars($k['owner_name']); ?>
                            <?php if (!empty($k['owner_email'])): ?>
                                <br><small style="color: #666;"><?php echo htmlspecialchars($k['owner_email']); ?></small>
                            <?php endif; ?>
                        <?php elseif (!empty($k['owner_email'])): ?>
                            <?php echo htmlspecialchars($k['owner_email']); ?>
                        <?php else: ?>
                            -
                        <?php endif; ?>
                    </td>
                    <td><?php echo htmlspecialchars($k['algorithm'] . ' ' . $k['key_bits'] . ' bits'); ?></td>
                    <td>
                        <code style="font-size: 10px;"><?php echo htmlspecialchars(substr($k['fingerprint'], 0, 16) . '...'); ?></code>
                        <button class="button" style="font-size: 10px; padding: 2px 6px;" onclick="copyToClipboard('<?php echo htmlspecialchars($k['fingerprint'], ENT_QUOTES); ?>')">Copy</button>
                    </td>
                    <td>
                        <?php
                        if (isset($k['is_owner']) && $k['is_owner']) {
                            echo '<strong>Owner</strong>';
                        } else {
                            echo '<span style="color: #666;">Shared</span>';
                        }
                        ?>
                    </td>
                    <td><?php echo htmlspecialchars(date('Y-m-d', strtotime($k['updated_at']))); ?></td>
                    <td>
                        <a href="/index.php?page=pgpkeys&action=view&id=<?php echo urlencode($k['id']); ?>" class="button">View</a>
                        <?php if (isset($k['is_owner']) && $k['is_owner']): ?>
                            <a href="/index.php?page=pgpkeys&action=edit&id=<?php echo urlencode($k['id']); ?>" class="button">Edit</a>
                        <?php endif; ?>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
<?php else: ?>
    <div class="alert alert-info">
        <strong>No PGP keys stored yet!</strong><br>
        Click "Import Key" to add a public PGP key to your key store.
    </div>
<?php endif; ?>
