<?php $title = 'Edit PGP Key'; ?>

<h1>Edit PGP Key</h1>

<form method="POST" action="/index.php?page=pgpkeys&action=update" enctype="multipart/form-data">
    <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($csrf_token ?? ''); ?>">
    <input type="hidden" name="id" value="<?php echo htmlspecialchars($key['id']); ?>">

    <div class="form-group">
        <label for="label">Label / Name: *</label>
        <input type="text" id="label" name="label" required autofocus
               value="<?php echo htmlspecialchars($key['label']); ?>">
    </div>

    <div class="form-group">
        <label for="owner_name">Key Owner Name:</label>
        <input type="text" id="owner_name" name="owner_name"
               value="<?php echo htmlspecialchars($key['owner_name'] ?? ''); ?>">
    </div>

    <div class="form-group">
        <label for="owner_email">Key Owner Email:</label>
        <input type="email" id="owner_email" name="owner_email"
               value="<?php echo htmlspecialchars($key['owner_email'] ?? ''); ?>">
    </div>

    <div class="form-group">
        <label for="public_key_file">Upload Replacement Key File:</label>
        <input type="file" id="public_key_file" name="public_key_file"
               accept=".pem,.pub,.asc,.gpg,.ppk,.eml,.key,.crt,.cer">
        <small>Upload a key file (.pem, .pub, .asc, .gpg, .ppk, .eml, .key, …) to replace the current key.</small>
    </div>

    <div class="form-group">
        <label for="public_key">— or paste replacement key text:</label>
        <textarea id="public_key" name="public_key" rows="12"
                  style="font-family: 'Courier New', monospace; font-size: 11px;"
                  placeholder="Leave blank to keep current key"><?php echo htmlspecialchars($key['public_key']); ?></textarea>
        <small>An uploaded file takes precedence. Leave both blank to keep the current key.</small>
    </div>

    <div class="form-group">
        <label for="tags">Tags:</label>
        <input type="text" id="tags" name="tags"
               value="<?php echo htmlspecialchars(implode(', ', $key['tags'] ?? [])); ?>">
    </div>

    <div class="form-group">
        <label for="notes">Notes:</label>
        <textarea id="notes" name="notes" rows="3"><?php echo htmlspecialchars($key['notes'] ?? ''); ?></textarea>
    </div>

    <div class="form-group">
        <label>
            <input type="checkbox" name="is_public" value="1"
                   <?php echo !empty($key['is_public']) ? 'checked' : ''; ?>>
            List this key in the public directory
        </label>
        <small>When checked, the key's label, owner name, email, fingerprint, algorithm, and public key text are visible to unauthenticated users. Notes and tags are never published.</small>
    </div>

    <div class="form-group">
        <button type="submit" class="button button-primary">Update PGP Key</button>
        <a href="/index.php?page=pgpkeys&action=view&id=<?php echo urlencode($key['id']); ?>" class="button">Cancel</a>
    </div>
</form>
