<?php $title = 'Import PGP Key'; ?>

<h1>Import Public PGP Key</h1>

<div class="alert alert-info">
    Paste a public key below. Accepted formats include:
    PEM/X.509 (<code>-----BEGIN PUBLIC KEY-----</code>),
    OpenPGP ASCII-armored (<code>-----BEGIN PGP PUBLIC KEY BLOCK-----</code>),
    SSH public key (<code>ssh-rsa …</code>, <code>ssh-ed25519 …</code>, <code>ecdsa-sha2-* …</code>),
    PuTTY key file (<code>.ppk</code>), and OpenSSH private key blocks.
</div>

<form method="POST" action="/index.php?page=pgpkeys&action=store" enctype="multipart/form-data">
    <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($csrf_token ?? ''); ?>">

    <div class="form-group">
        <label for="label">Label / Name: *</label>
        <input type="text" id="label" name="label" required autofocus
               placeholder="e.g., Alice's Signing Key, Server Deploy Key">
    </div>

    <div class="form-group">
        <label for="owner_name">Key Owner Name:</label>
        <input type="text" id="owner_name" name="owner_name"
               placeholder="e.g., Alice Smith">
    </div>

    <div class="form-group">
        <label for="owner_email">Key Owner Email:</label>
        <input type="email" id="owner_email" name="owner_email"
               placeholder="e.g., alice@example.com">
    </div>

    <div class="form-group">
        <label for="public_key_file">Upload Key File:</label>
        <input type="file" id="public_key_file" name="public_key_file"
               accept=".pem,.pub,.asc,.gpg,.ppk,.eml,.key,.crt,.cer">
        <small>Upload a key file (.pem, .pub, .asc, .gpg, .ppk, .eml, .key, …)</small>
    </div>

    <div class="form-group">
        <label for="public_key">— or paste key text: *</label>
        <textarea id="public_key" name="public_key" rows="12"
                  style="font-family: 'Courier New', monospace; font-size: 11px;"
                  placeholder="Paste your public key here (PEM, OpenPGP, SSH, PuTTY, OpenSSH, etc.)"></textarea>
        <small>An uploaded file takes precedence over pasted text.</small>
    </div>

    <div class="form-group">
        <label for="tags">Tags:</label>
        <input type="text" id="tags" name="tags"
               placeholder="Comma separated: work, signing, encryption">
    </div>

    <div class="form-group">
        <label for="notes">Notes:</label>
        <textarea id="notes" name="notes" rows="3"
                  placeholder="Additional information about this key..."></textarea>
    </div>

    <div class="form-group">
        <label>
            <input type="checkbox" name="is_public" value="1">
            List this key in the public directory
        </label>
        <small>When checked, the key's label, owner name, email, fingerprint, algorithm, and public key text will be visible to anyone without an account. Notes and tags are never published.</small>
    </div>

    <?php if (!empty($user_groups)): ?>
    <div class="form-group">
        <label for="group_ids">Share with Groups:</label>
        <select id="group_ids" name="group_ids[]" multiple style="height: auto; min-height: 60px;">
            <?php foreach ($user_groups as $group): ?>
                <option value="<?php echo htmlspecialchars($group['id']); ?>">
                    <?php echo htmlspecialchars($group['name']); ?>
                </option>
            <?php endforeach; ?>
        </select>
        <small>Hold Ctrl/Cmd to select multiple groups. Leave unselected to keep private.</small>
    </div>
    <?php endif; ?>

    <div class="form-group">
        <button type="submit" class="button button-primary">Store PGP Key</button>
        <a href="/index.php?page=pgpkeys" class="button">Cancel</a>
    </div>
</form>
