<?php $title = 'PGP Keys'; ?>

<h1>Your PGP Keys</h1>

<?php if (isset($success) && $success): ?>
    <div class="alert alert-success">
        <?php echo htmlspecialchars($success); ?>
    </div>
<?php endif; ?>

<?php if (isset($error) && $error): ?>
    <div class="alert alert-danger">
        <?php echo htmlspecialchars($error); ?>
    </div>
<?php endif; ?>

<?php if ($user['has_pgp_key'] && $public_key): ?>
    <div class="panel">
        <h2>Key Information</h2>
        <table>
            <tr>
                <td style="width: 150px;"><strong>Status:</strong></td>
                <td><span style="color: green;">&#10003; Active</span></td>
            </tr>
            <tr>
                <td><strong>Algorithm:</strong></td>
                <td>
                    <?php
                    $algorithm = $user['pgp_algorithm'] ?? 'RSA';
                    $keySize   = $user['pgp_key_size'] ?? '4096 bits';
                    echo htmlspecialchars($algorithm . ' ' . $keySize);
                    ?>
                </td>
            </tr>
            <tr>
                <td><strong>Email:</strong></td>
                <td><?php echo htmlspecialchars($user['email']); ?></td>
            </tr>
            <tr>
                <td><strong>Fingerprint:</strong></td>
                <td style="display: flex; align-items: center; gap: 10px;">
                    <code style="flex: 1; font-size: 10px; word-break: break-all;"><?php echo htmlspecialchars($fingerprint); ?></code>
                    <button class="button" onclick="copyToClipboard('<?php echo htmlspecialchars($fingerprint, ENT_QUOTES); ?>')">Copy</button>
                </td>
            </tr>
        </table>
    </div>

    <h2>Public Key</h2>
    <div class="alert alert-info">
        Your public key is used by other users to encrypt credentials they share with you. It's safe to share publicly.
    </div>

    <div class="panel">
        <textarea id="pgp-public-key" readonly rows="15" style="width: 100%; font-family: 'Courier New', monospace; font-size: 11px;"><?php echo htmlspecialchars($public_key); ?></textarea>
    </div>

    <div class="form-group">
        <button class="button" onclick="copyPublicKey()">Copy Public Key</button>
        <button class="button" onclick="downloadPublicKey()">Download Public Key</button>
    </div>

    <script>
    function copyPublicKey() {
        const textarea = document.getElementById('pgp-public-key');
        textarea.select();
        document.execCommand('copy');
        showNotification('Public key copied to clipboard!', 'success');
    }

    function downloadPublicKey() {
        const publicKey = document.getElementById('pgp-public-key').value;
        const blob = new Blob([publicKey], { type: 'text/plain' });
        const url = window.URL.createObjectURL(blob);
        const a = document.createElement('a');
        a.href = url;
        a.download = 'pgp-public-key.asc';
        document.body.appendChild(a);
        a.click();
        document.body.removeChild(a);
        window.URL.revokeObjectURL(url);
        showNotification('Public key downloaded!', 'success');
    }
    </script>

    <h2>Private Key</h2>
    <div class="alert alert-warning">
        <strong>Security Notice:</strong><br>
        Your private key is stored encrypted on the server. It can only be decrypted with your PGP passphrase. Never share your private key!
    </div>

    <div class="panel-gray">
        <p><strong>Location:</strong> data/pgp/<?php echo htmlspecialchars($user['id']); ?>_private.key.enc</p>
        <p><strong>Encryption:</strong> AES-256-GCM with your PGP passphrase (Argon2id key derivation)</p>
    </div>

    <!-- ===================================================================
         PGP ENCRYPTION MODE
         =================================================================== -->
    <hr style="margin-top: 30px;">
    <h2>Encryption Mode</h2>

    <?php if ($pgp_mode_enabled): ?>
        <div class="alert alert-success">
            <strong>&#128274; PGP Encryption Mode is ACTIVE</strong><br>
            Your credentials and public-key store are encrypted with your PGP key pair instead of
            the shared master application key. Only you can decrypt your data.
        </div>

        <?php if ($passphrase_in_session): ?>
            <div class="panel">
                <p><strong>Session Status:</strong> <span style="color: green;">&#10003; PGP key unlocked for this session</span></p>
                <p style="font-size: 13px; color: #555;">
                    Your passphrase is held in your server session and will be cleared on logout.
                </p>
                <form method="post" action="/index.php?page=pgp&action=lock-pgp" style="margin-top: 10px;">
                    <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($csrf_token); ?>">
                    <button type="submit" class="button">Lock PGP Key (clear from session)</button>
                </form>
            </div>
        <?php else: ?>
            <div class="alert alert-warning">
                <strong>&#128275; PGP key is locked</strong><br>
                Enter your passphrase below to unlock it for this session so your credentials can be read and written.
            </div>
        <?php endif; ?>

    <?php else: ?>
        <div class="panel">
            <p>
                <strong>Current mode: Standard AES-256-GCM</strong><br>
                Your data is encrypted using the master application key stored in <code>config/security.php</code>.
            </p>
            <p style="font-size: 13px; color: #555;">
                Switch to <strong>PGP Encryption Mode</strong> to have your credentials and public-key
                store encrypted exclusively with your personal PGP key pair. The master application
                key will no longer be used for your files.
            </p>
        </div>
    <?php endif; ?>

    <!-- Passphrase unlock form (shown when PGP mode is active but key is locked,
         OR when the user wants to unlock before switching mode) -->
    <?php if (!$passphrase_in_session): ?>
    <div class="panel" id="unlock-panel">
        <h3>Unlock PGP Key</h3>
        <p style="font-size: 13px;">
            Enter the passphrase you chose when you generated your PGP key pair.
            It will be stored securely in your server-side session and cleared on logout.
        </p>
        <form method="post" action="/index.php?page=pgp&action=unlock-pgp">
            <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($csrf_token); ?>">
            <div class="form-group">
                <label for="unlock-passphrase"><strong>PGP Passphrase:</strong></label>
                <input type="password" id="unlock-passphrase" name="passphrase"
                       class="form-control" placeholder="Enter your PGP passphrase" required>
            </div>
            <button type="submit" class="button button-primary">Unlock PGP Key</button>
        </form>
    </div>
    <?php endif; ?>

    <!-- Mode toggle -->
    <div class="panel" style="margin-top: 20px;">
        <h3><?php echo $pgp_mode_enabled ? 'Disable PGP Encryption Mode' : 'Enable PGP Encryption Mode'; ?></h3>

        <?php if ($pgp_mode_enabled): ?>
            <div class="alert alert-warning" style="font-size: 13px;">
                <strong>Switching back to AES mode</strong> will re-encrypt your files with the master
                application key. Your PGP passphrase must be unlocked (see above) to perform the migration.
            </div>
        <?php else: ?>
            <div class="alert alert-info" style="font-size: 13px;">
                <strong>Enabling PGP mode</strong> will migrate your existing credential and public-key files
                to be encrypted with your PGP key pair. Your PGP passphrase must be unlocked (see above)
                to perform the migration.<br><br>
                <strong>Note:</strong> Group-shared credentials owned by other users remain in AES mode
                and are not affected by this setting.
            </div>
        <?php endif; ?>

        <?php if ($passphrase_in_session): ?>
            <form method="post" action="/index.php?page=pgp&action=toggle-encryption">
                <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($csrf_token); ?>">
                <?php if ($pgp_mode_enabled): ?>
                    <button type="submit" class="button"
                            onclick="return confirm('Revert to AES encryption? Your files will be re-encrypted with the master application key.')">
                        Switch to AES Encryption
                    </button>
                <?php else: ?>
                    <button type="submit" class="button button-primary"
                            onclick="return confirm('Enable PGP encryption? Your files will be re-encrypted with your PGP key pair.')">
                        Enable PGP Encryption
                    </button>
                <?php endif; ?>
            </form>
        <?php else: ?>
            <p style="font-size: 13px; color: #888;">
                Unlock your PGP key above to enable or disable this mode.
            </p>
        <?php endif; ?>
    </div>

    <!-- Storage info -->
    <div class="panel-gray" style="margin-top: 10px; font-size: 12px;">
        <strong>Storage format in each mode:</strong>
        <table style="margin-top: 8px; font-size: 12px; width: 100%;">
            <thead>
                <tr>
                    <th style="text-align:left; padding: 4px;">File</th>
                    <th style="text-align:left; padding: 4px;">AES mode</th>
                    <th style="text-align:left; padding: 4px;">PGP mode</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td style="padding: 4px;">Credentials</td>
                    <td style="padding: 4px;"><code>{user}.json.enc</code> – AES-256-GCM</td>
                    <td style="padding: 4px;"><code>{user}.pgp.enc</code> – RSA+AES-256-GCM</td>
                </tr>
                <tr>
                    <td style="padding: 4px;">Public Keys</td>
                    <td style="padding: 4px;"><code>{user}.json.enc</code> – AES-256-GCM</td>
                    <td style="padding: 4px;"><code>{user}.json</code> – plain JSON</td>
                </tr>
            </tbody>
        </table>
    </div>

<?php else: ?>
    <div class="alert alert-warning">
        <strong>No PGP keys found!</strong><br>
        You need to generate PGP keys to use PGP encryption mode or share/receive encrypted credentials.
    </div>

    <p>
        <a href="/index.php?page=pgp&action=show-generate" class="button button-primary">Generate PGP Keys Now</a>
    </p>
<?php endif; ?>

<hr style="margin-top: 30px;">

<h2>What can I do with PGP keys?</h2>
<div class="panel">
    <ul>
        <li><strong>Share Credentials:</strong> Encrypt credentials with another user's public key</li>
        <li><strong>Receive Credentials:</strong> Decrypt credentials shared with you using your private key</li>
        <li><strong>PGP Encryption Mode:</strong> Store your own credentials encrypted with your personal key instead of the shared master key</li>
    </ul>
</div>

<p style="margin-top: 20px;">
    <a href="/index.php?page=dashboard" class="button">Back to Dashboard</a>
</p>
