<?php $title = 'Generate PGP Keys'; ?>

<h1>Generate PGP Key Pair</h1>

<?php if ($user['has_pgp_key']): ?>
    <div class="alert alert-warning">
        <strong>You already have PGP keys!</strong><br>
        Generating new keys will replace your existing ones. Any credentials shared with your old public key will become inaccessible.
    </div>
<?php else: ?>
    <div class="alert alert-info">
        <strong>Why Generate PGP Keys?</strong><br>
        PGP keys allow you to securely share credentials with other users. Your public key encrypts data that only your private key can decrypt.
    </div>
<?php endif; ?>

<?php if (isset($error) && $error): ?>
    <div class="alert alert-error">
        <?php echo htmlspecialchars($error); ?>
    </div>
<?php endif; ?>

<div class="panel">
    <h2>Key Generation Settings</h2>

    <form method="POST" action="/index.php?page=pgp&action=generate">
        <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($csrf_token ?? ''); ?>">

        <div class="alert alert-warning">
            <strong>Important:</strong> You will need to enter your master password to encrypt your private key. This is the same password you use to log in to PassGram.
        </div>

        <div class="form-group">
            <label for="key_type">Encryption Algorithm: *</label>
            <select id="key_type" name="key_type" required onchange="updateKeyInfo()">
                <option value="RSA" selected>RSA (Recommended)</option>
                <option value="DSA">DSA (Legacy)</option>
                <option value="EC">Elliptic Curve (Modern)</option>
            </select>
            <small id="key_type_info">RSA is the most widely supported algorithm for PGP encryption</small>
        </div>

        <div class="form-group" id="key_size_group">
            <label for="key_size">Key Size: *</label>
            <select id="key_size" name="key_size" required onchange="updateKeyInfo()">
                <option value="2048">2048 bits (Fast, Standard)</option>
                <option value="3072">3072 bits (Balanced)</option>
                <option value="4096" selected>4096 bits (Maximum Security)</option>
            </select>
            <small id="key_size_info">Larger keys are more secure but slower. 4096 bits recommended.</small>
        </div>

        <div class="form-group" id="ec_curve_group" style="display: none;">
            <label for="ec_curve">Elliptic Curve: *</label>
            <select id="ec_curve" name="ec_curve">
                <option value="secp384r1">secp384r1 (NIST P-384, Recommended)</option>
                <option value="secp521r1">secp521r1 (NIST P-521, Maximum)</option>
                <option value="prime256v1">prime256v1 (NIST P-256)</option>
            </select>
            <small>Elliptic Curve keys provide strong security with smaller key sizes</small>
        </div>

        <div class="form-group">
            <label for="passphrase">Master Password: *</label>
            <input type="password" id="passphrase" name="passphrase" required
                   placeholder="Your PassGram login password">
            <small>Your private key will be encrypted with this password</small>
        </div>

        <div class="panel-gray">
            <p><strong>Key Specifications:</strong></p>
            <ul>
                <li><strong>Algorithm:</strong> <span id="display_algorithm">RSA</span></li>
                <li><strong>Key Size:</strong> <span id="display_key_size">4096 bits</span></li>
                <li><strong>Email:</strong> <?php echo htmlspecialchars($user['email']); ?></li>
                <li><strong>Security Level:</strong> <span id="display_security">Maximum</span></li>
            </ul>
        </div>

        <script>
        function updateKeyInfo() {
            const keyType = document.getElementById('key_type').value;
            const keySize = document.getElementById('key_size').value;
            const ecCurve = document.getElementById('ec_curve').value;

            const displayAlg = document.getElementById('display_algorithm');
            const displaySize = document.getElementById('display_key_size');
            const displaySecurity = document.getElementById('display_security');
            const keyTypeInfo = document.getElementById('key_type_info');
            const keySizeInfo = document.getElementById('key_size_info');

            // Show/hide relevant fields
            if (keyType === 'EC') {
                document.getElementById('key_size_group').style.display = 'none';
                document.getElementById('ec_curve_group').style.display = 'block';
                displayAlg.textContent = 'Elliptic Curve';
                displaySize.textContent = ecCurve;
                keyTypeInfo.textContent = 'Elliptic Curve provides strong security with smaller key sizes. Note: Limited compatibility with older systems.';
                displaySecurity.textContent = ecCurve === 'secp521r1' ? 'Maximum' : 'High';
            } else {
                document.getElementById('key_size_group').style.display = 'block';
                document.getElementById('ec_curve_group').style.display = 'none';
                displayAlg.textContent = keyType;
                displaySize.textContent = keySize + ' bits';

                if (keyType === 'RSA') {
                    keyTypeInfo.textContent = 'RSA is the most widely supported algorithm for PGP encryption';
                    if (keySize === '4096') {
                        displaySecurity.textContent = 'Maximum';
                        keySizeInfo.textContent = 'Maximum security, recommended for sensitive data. Slower performance.';
                    } else if (keySize === '3072') {
                        displaySecurity.textContent = 'High';
                        keySizeInfo.textContent = 'Balanced security and performance. Good for most use cases.';
                    } else {
                        displaySecurity.textContent = 'Standard';
                        keySizeInfo.textContent = 'Standard security, faster performance. Minimum recommended size.';
                    }
                } else if (keyType === 'DSA') {
                    keyTypeInfo.textContent = 'DSA is a legacy algorithm. Use only for compatibility with old systems.';
                    displaySecurity.textContent = keySize === '3072' ? 'High' : 'Standard';
                    keySizeInfo.textContent = 'DSA is primarily for signing, not recommended for new deployments.';
                }
            }
        }
        </script>

        <div class="form-group" style="margin-top: 20px;">
            <button type="submit" class="button button-primary">Generate PGP Key Pair</button>
            <a href="/index.php?page=dashboard" class="button">Cancel</a>
        </div>
    </form>
</div>

<div class="alert alert-info" style="margin-top: 20px;">
    <strong>What happens next?</strong><br>
    <ul style="margin-left: 20px; margin-top: 10px;">
        <li>Your selected key pair will be generated using secure random numbers</li>
        <li>Your private key will be encrypted with AES-256-GCM using your master password</li>
        <li>Your public key will be stored and available for other users</li>
        <li>You'll be able to share and receive encrypted credentials securely</li>
    </ul>
</div>

<div class="alert alert-warning" style="margin-top: 10px;">
    <strong>Algorithm Comparison:</strong><br>
    <ul style="margin-left: 20px; margin-top: 10px; font-size: 11px;">
        <li><strong>RSA:</strong> Most compatible, widely supported, proven security. Recommended for general use.</li>
        <li><strong>DSA:</strong> Legacy algorithm, limited to signing only, not recommended for new systems.</li>
        <li><strong>Elliptic Curve:</strong> Modern, efficient, strong security with smaller keys. May have compatibility issues with older systems.</li>
    </ul>
</div>
