<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($title ?? 'PassGram v3.0'); ?></title>
    <link rel="stylesheet" href="/assets/css/style.css">
</head>
<body>
    <?php
    // Show navigation if user is logged in
    use PassGram\Core\Session;
    if (Session::has('user_id')):
        // Get user data if not already set
        if (!isset($user)) {
            $user = [
                'username' => Session::get('username', 'User')
            ];
        }
    ?>
        <?php require __DIR__ . '/navigation.php'; ?>
    <?php endif; ?>

    <div class="window window-large">
        <div class="title-bar">
            <span class="title-bar-text"><?php echo htmlspecialchars($title ?? 'PassGram v3.0'); ?></span>
            <div class="title-bar-controls">
                <span class="title-bar-button">_</span>
                <span class="title-bar-button">□</span>
                <span class="title-bar-button">X</span>
            </div>
        </div>
        <div class="window-body">
