<?php
use PassGram\Core\Session;
$title = 'Invite Codes';
?>

<h1>Invite Codes</h1>

<?php if (isset($success) && $success): ?>
    <div class="alert alert-success no-auto-hide">
        <?php echo htmlspecialchars($success); ?>
        <?php
        $newInvite = Session::get('new_invite_code');
        if ($newInvite):
            Session::remove('new_invite_code');
            $registrationUrl = $_SERVER['REQUEST_SCHEME'] . '://' . $_SERVER['HTTP_HOST'] . '/register.php?invite=' . $newInvite;
        ?>
            <div style="margin-top: 15px; padding: 10px; background: rgba(255,255,255,0.2); border: 1px solid #fff;">
                <p style="margin: 0 0 5px 0;"><strong>New Invite Code:</strong></p>
                <div style="display: flex; align-items: center; gap: 10px; margin-bottom: 10px;">
                    <code style="flex: 1; padding: 5px; background: #fff; color: #000; font-size: 11px; word-break: break-all;"><?php echo htmlspecialchars($newInvite); ?></code>
                    <button class="button" onclick="copyToClipboard('<?php echo htmlspecialchars($newInvite, ENT_QUOTES); ?>')">Copy Code</button>
                </div>

                <p style="margin: 10px 0 5px 0;"><strong>Registration URL:</strong></p>
                <div style="display: flex; align-items: center; gap: 10px;">
                    <code style="flex: 1; padding: 5px; background: #fff; color: #000; font-size: 10px; word-break: break-all;"><?php echo htmlspecialchars($registrationUrl); ?></code>
                    <button class="button" onclick="copyToClipboard('<?php echo htmlspecialchars($registrationUrl, ENT_QUOTES); ?>')">Copy URL</button>
                </div>
            </div>
        <?php endif; ?>
    </div>
<?php endif; ?>

<?php if (isset($error) && $error): ?>
    <div class="alert alert-error">
        <?php echo htmlspecialchars($error); ?>
    </div>
<?php endif; ?>

<div class="panel">
    <h2>Generate New Invite</h2>
    <form method="POST" action="/index.php?page=invites&action=generate">
        <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($csrf_token ?? ''); ?>">

        <div class="form-group">
            <label for="group_id">Select Group:</label>
            <select id="group_id" name="group_id" required>
                <?php foreach ($groups as $group): ?>
                    <option value="<?php echo htmlspecialchars($group['id']); ?>">
                        <?php echo htmlspecialchars($group['name']); ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div class="form-group">
            <button type="submit" class="button button-primary">Generate Invite Code</button>
        </div>
    </form>
</div>

<h2>Active Invites</h2>
<?php if (!empty($invites)): ?>
    <table>
        <thead>
            <tr>
                <th>Code</th>
                <th>Group</th>
                <th>Status</th>
                <th>Used</th>
                <th>Expires</th>
                <th>Created</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($invites as $invite):
                $regUrl = $_SERVER['REQUEST_SCHEME'] . '://' . $_SERVER['HTTP_HOST'] . '/register.php?invite=' . $invite['code'];
            ?>
                <tr>
                    <td>
                        <code style="font-size: 10px;"><?php echo htmlspecialchars(substr($invite['code'], 0, 16) . '...'); ?></code>
                        <button class="button" style="font-size: 10px; padding: 2px 6px;" onclick="copyToClipboard('<?php echo htmlspecialchars($invite['code'], ENT_QUOTES); ?>')">Copy</button>
                        <button class="button" style="font-size: 10px; padding: 2px 6px;" onclick="copyToClipboard('<?php echo htmlspecialchars($regUrl, ENT_QUOTES); ?>')">URL</button>
                    </td>
                    <td><?php echo htmlspecialchars($invite['group_name']); ?></td>
                    <td><?php echo htmlspecialchars($invite['status']); ?></td>
                    <td><?php echo $invite['used_count']; ?></td>
                    <td><?php echo $invite['expires_at'] ? htmlspecialchars(date('Y-m-d', strtotime($invite['expires_at']))) : 'Never'; ?></td>
                    <td><?php echo htmlspecialchars(date('Y-m-d', strtotime($invite['created_at']))); ?></td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
<?php else: ?>
    <div class="alert alert-info">
        No invites created yet.
    </div>
<?php endif; ?>
