<?php $title = 'Group Details'; ?>

<h1><?php echo htmlspecialchars($group['name'] ?? 'Group'); ?></h1>

<?php if (isset($success) && $success): ?>
    <div class="alert alert-success">
        <?php echo htmlspecialchars($success); ?>
    </div>
<?php endif; ?>

<?php if (isset($error) && $error): ?>
    <div class="alert alert-error">
        <?php echo htmlspecialchars($error); ?>
    </div>
<?php endif; ?>

<div class="panel">
    <p><strong>Description:</strong> <?php echo htmlspecialchars($group['description']); ?></p>
    <p><strong>Created:</strong> <?php echo htmlspecialchars(date('Y-m-d H:i', strtotime($group['created_at']))); ?></p>
    <p><strong>Members:</strong> <?php echo count($group['member_ids']); ?></p>
</div>

<h2>Group Members</h2>
<?php if (!empty($members)): ?>
    <table>
        <thead>
            <tr>
                <th>Username</th>
                <th>Email</th>
                <th>PGP Key</th>
                <th>Joined</th>
                <?php if ($is_owner): ?>
                    <th>Actions</th>
                <?php endif; ?>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($members as $member): ?>
                <tr>
                    <td><?php echo htmlspecialchars($member['username']); ?></td>
                    <td><?php echo htmlspecialchars($member['email']); ?></td>
                    <td><?php echo $member['has_pgp_key'] ? '<span style="color: green;">✓</span>' : '<span style="color: red;">✗</span>'; ?></td>
                    <td><?php echo htmlspecialchars(date('Y-m-d', strtotime($member['created_at']))); ?></td>
                    <?php if ($is_owner): ?>
                        <td>
                            <?php if ($member['id'] !== $group['owner_id']): ?>
                                <form method="POST" action="/index.php?page=groups&action=remove-member" style="display: inline;">
                                    <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($csrf_token); ?>">
                                    <input type="hidden" name="group_id" value="<?php echo htmlspecialchars($group['id']); ?>">
                                    <input type="hidden" name="member_id" value="<?php echo htmlspecialchars($member['id']); ?>">
                                    <button type="submit" class="button" onclick="return confirm('Remove this member from the group?')">Remove</button>
                                </form>
                            <?php else: ?>
                                <em>Owner</em>
                            <?php endif; ?>
                        </td>
                    <?php endif; ?>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
<?php else: ?>
    <div class="alert alert-info">
        No members in this group.
    </div>
<?php endif; ?>

<?php if ($is_owner): ?>
    <h2>Group Administration</h2>

    <div class="panel">
        <h3>Add Member</h3>
        <form method="POST" action="/index.php?page=groups&action=add-member">
            <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($csrf_token); ?>">
            <input type="hidden" name="group_id" value="<?php echo htmlspecialchars($group['id']); ?>">

            <div class="form-group">
                <label for="username">Username:</label>
                <input type="text" id="username" name="username" required>
            </div>

            <button type="submit" class="button">Add Member</button>
        </form>
    </div>

    <div class="panel" style="margin-top: 20px;">
        <h3>Transfer Ownership</h3>
        <form method="POST" action="/index.php?page=groups&action=transfer-ownership" onsubmit="return confirm('Are you sure you want to transfer ownership? You will no longer be the group owner.');">
            <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($csrf_token); ?>">
            <input type="hidden" name="group_id" value="<?php echo htmlspecialchars($group['id']); ?>">

            <div class="form-group">
                <label for="new_owner_id">Transfer to:</label>
                <select id="new_owner_id" name="new_owner_id" required>
                    <option value="">-- Select Member --</option>
                    <?php foreach ($members as $member): ?>
                        <?php if ($member['id'] !== $group['owner_id']): ?>
                            <option value="<?php echo htmlspecialchars($member['id']); ?>">
                                <?php echo htmlspecialchars($member['username']); ?>
                            </option>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </select>
            </div>

            <button type="submit" class="button">Transfer Ownership</button>
        </form>
    </div>

    <div class="panel" style="margin-top: 20px;">
        <h3>Other Actions</h3>
        <p>
            <a href="/index.php?page=groups&action=edit&id=<?php echo urlencode($group['id']); ?>" class="button">Edit Group</a>
            <a href="/index.php?page=invites" class="button">Generate Invite Code</a>
        </p>

        <form method="POST" action="/index.php?page=groups&action=delete" style="margin-top: 10px;" onsubmit="return confirm('Are you sure you want to delete this group? This action cannot be undone.');">
            <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($csrf_token); ?>">
            <input type="hidden" name="id" value="<?php echo htmlspecialchars($group['id']); ?>">
            <button type="submit" class="button" style="background-color: #800000;">Delete Group</button>
        </form>
    </div>
<?php endif; ?>

<p style="margin-top: 20px;">
    <a href="/index.php?page=groups" class="button">Back to Groups</a>
</p>
