<?php $title = 'Groups'; ?>

<h1>My Groups</h1>

<?php if (isset($success) && $success): ?>
    <div class="alert alert-success">
        <?php echo htmlspecialchars($success); ?>
    </div>
<?php endif; ?>

<?php if (isset($error) && $error): ?>
    <div class="alert alert-error">
        <?php echo htmlspecialchars($error); ?>
    </div>
<?php endif; ?>

<p style="margin-bottom: 20px;">
    <a href="/index.php?page=groups&action=create" class="button">Create New Group</a>
</p>

<?php if (!empty($groups)): ?>
    <table>
        <thead>
            <tr>
                <th>Group Name</th>
                <th>Description</th>
                <th>Members</th>
                <th>Created</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($groups as $group): ?>
                <tr>
                    <td><strong><?php echo htmlspecialchars($group['name']); ?></strong></td>
                    <td><?php echo htmlspecialchars($group['description']); ?></td>
                    <td><?php echo count($group['member_ids']); ?></td>
                    <td><?php echo htmlspecialchars(date('Y-m-d', strtotime($group['created_at']))); ?></td>
                    <td>
                        <a href="/index.php?page=groups&action=view&id=<?php echo urlencode($group['id']); ?>" class="button">View</a>
                        <?php if ($group['owner_id'] === PassGram\Core\Session::get('user_id')): ?>
                            <a href="/index.php?page=groups&action=edit&id=<?php echo urlencode($group['id']); ?>" class="button">Edit</a>
                        <?php endif; ?>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
<?php else: ?>
    <div class="alert alert-info">
        You are not a member of any groups yet.
    </div>
<?php endif; ?>
