<?php $title = 'Edit Group'; ?>

<h1>Edit Group</h1>

<form method="POST" action="/index.php?page=groups&action=update">
    <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($csrf_token); ?>">
    <input type="hidden" name="id" value="<?php echo htmlspecialchars($group['id']); ?>">

    <div class="form-group">
        <label for="name">Group Name: *</label>
        <input type="text" id="name" name="name" value="<?php echo htmlspecialchars($group['name']); ?>" required minlength="3" maxlength="100">
        <small>Minimum 3 characters, maximum 100 characters</small>
    </div>

    <div class="form-group">
        <label for="description">Description:</label>
        <textarea id="description" name="description" rows="4"><?php echo htmlspecialchars($group['description']); ?></textarea>
    </div>

    <div class="form-actions">
        <button type="submit" class="button">Update Group</button>
        <a href="/index.php?page=groups&action=view&id=<?php echo urlencode($group['id']); ?>" class="button">Cancel</a>
    </div>
</form>
