<?php $title = 'Dashboard'; ?>

<?php if (isset($stats)): ?>
    <div class="panel">
        <h2>Welcome to PassGram</h2>
        <p>Secure password management with PGP encryption and group collaboration.</p>
    </div>

    <div class="flex gap-10" style="margin-bottom: 20px;">
        <div class="panel" style="flex: 1;">
            <h3>Statistics</h3>
            <table>
                <tr>
                    <td><strong>Total Credentials:</strong></td>
                    <td><?php echo (int)$stats['total_credentials']; ?></td>
                </tr>
                <tr>
                    <td><strong>Shared with Me:</strong></td>
                    <td><?php echo (int)$stats['shared_with_me']; ?></td>
                </tr>
                <tr>
                    <td><strong>Groups:</strong></td>
                    <td><?php echo (int)$stats['groups']; ?></td>
                </tr>
                <tr>
                    <td><strong>PGP Key Status:</strong></td>
                    <td><?php echo $stats['has_pgp_key'] ? '<span style="color: green;">✓ Generated</span>' : '<span style="color: red;">✗ Not Generated</span>'; ?></td>
                </tr>
            </table>
        </div>

        <div class="panel" style="flex: 1;">
            <h3>Quick Actions</h3>
            <div style="display: flex; flex-direction: column; gap: 10px;">
                <a href="/index.php?page=credentials&action=create" class="button" style="display: block; text-align: center;">New Credential</a>
                <?php if (!$stats['has_pgp_key']): ?>
                    <a href="/index.php?page=pgp&action=show-generate" class="button" style="display: block; text-align: center;">Generate PGP Keys</a>
                <?php endif; ?>
                <a href="/index.php?page=invites" class="button" style="display: block; text-align: center;">Generate Invite</a>
            </div>
        </div>
    </div>

    <h2>Recent Credentials</h2>
    <?php if (!empty($recent_credentials)): ?>
        <table>
            <thead>
                <tr>
                    <th>Title</th>
                    <th>Type</th>
                    <th>Username</th>
                    <th>Last Accessed</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($recent_credentials as $cred): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($cred['title']); ?></td>
                        <td><?php echo htmlspecialchars($cred['type']); ?></td>
                        <td><?php echo htmlspecialchars($cred['username'] ?? '-'); ?></td>
                        <td><?php echo htmlspecialchars(date('Y-m-d H:i', strtotime($cred['accessed_at']))); ?></td>
                        <td>
                            <a href="/index.php?page=credentials&action=view&id=<?php echo urlencode($cred['id']); ?>" class="button">View</a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php else: ?>
        <div class="alert alert-info">
            No credentials yet. <a href="/index.php?page=credentials&action=create">Create your first credential</a>
        </div>
    <?php endif; ?>

    <?php if (!empty($shared_credentials)): ?>
        <h2 style="margin-top: 30px;">Credentials Shared with Me</h2>
        <div class="alert alert-info">
            You have <?php echo count($shared_credentials); ?> credential(s) shared with you.
            <a href="/index.php?page=shares">View shared credentials</a>
        </div>
    <?php endif; ?>

    <?php if (!empty($groups)): ?>
        <h2 style="margin-top: 30px;">Your Groups</h2>
        <ul>
            <?php foreach ($groups as $group): ?>
                <li>
                    <a href="/index.php?page=groups&action=view&id=<?php echo urlencode($group['id']); ?>">
                        <?php echo htmlspecialchars($group['name']); ?>
                    </a>
                    - <?php echo count($group['member_ids']); ?> members
                </li>
            <?php endforeach; ?>
        </ul>
    <?php endif; ?>
<?php endif; ?>
