<?php $title = 'View Credential'; ?>

<?php if (isset($success) && $success): ?>
    <div class="alert alert-success">
        <?php echo htmlspecialchars($success); ?>
    </div>
<?php endif; ?>

<?php if (isset($error) && $error): ?>
    <div class="alert alert-error">
        <?php echo htmlspecialchars($error); ?>
    </div>
<?php endif; ?>

<?php if (!empty($public_share_url)): ?>
    <div class="alert alert-success no-auto-hide">
        <strong>Public link created — one-time use only:</strong><br>
        <code id="pub-link" style="word-break:break-all; display:block; margin:8px 0;"><?php echo htmlspecialchars($public_share_url); ?></code>
        <button class="button" onclick="copyToClipboard('<?php echo htmlspecialchars($public_share_url, ENT_QUOTES); ?>')">Copy Link</button>
        <small style="display:block; margin-top:6px; color:#555;">This link will expire after the recipient opens it once.</small>
    </div>
<?php endif; ?>

<div class="flex-between" style="margin-bottom: 20px;">
    <h1>
        <?php echo htmlspecialchars($credential['title'] ?? 'Credential'); ?>
        <?php if (isset($is_owner) && !$is_owner): ?>
            <small style="color: #666; font-size: 14px;">(Shared via group<?php
                if (isset($credential['access_level'])) {
                    echo ' - ' . ($credential['access_level'] === 'write' ? 'Read & Write' : 'Read Only');
                }
            ?>)</small>
        <?php endif; ?>
    </h1>
    <div>
        <?php if (!isset($is_owner) || $is_owner || (isset($access_level) && $access_level === 'write')): ?>
            <a href="/index.php?page=credentials&action=edit&id=<?php echo urlencode($credential['id']); ?>" class="button">Edit</a>
        <?php endif; ?>
        <?php if (!isset($is_owner) || $is_owner): ?>
            <a href="/index.php?page=shares&action=share&id=<?php echo urlencode($credential['id']); ?>" class="button">Share</a>
        <?php endif; ?>
        <a href="/index.php?page=credentials" class="button">Back to List</a>
    </div>
</div>

<div class="panel">
    <table>
        <tr>
            <td style="width: 150px;"><strong>Type:</strong></td>
            <td><?php echo htmlspecialchars($credential['type']); ?></td>
        </tr>
        <?php if ($credential['username']): ?>
        <tr>
            <td><strong>Username:</strong></td>
            <td style="display: flex; align-items: center; gap: 10px;">
                <code style="flex: 1;"><?php echo htmlspecialchars($credential['username']); ?></code>
                <button class="button" onclick="copyToClipboard('<?php echo htmlspecialchars($credential['username'], ENT_QUOTES); ?>')">Copy</button>
            </td>
        </tr>
        <?php endif; ?>

        <?php if ($credential['password']): ?>
        <tr>
            <td><strong>Password:</strong></td>
            <td style="display: flex; align-items: center; gap: 10px;">
                <code id="password-field" style="flex: 1;">••••••••</code>
                <button class="button" id="toggle-password-btn" onclick="togglePasswordView()">Show</button>
                <button class="button" onclick="copyToClipboard('<?php echo htmlspecialchars($credential['password'], ENT_QUOTES); ?>')">Copy</button>
                <input type="hidden" id="password-value" value="<?php echo htmlspecialchars($credential['password']); ?>">
            </td>
        </tr>
        <?php endif; ?>

        <?php if ($credential['url']): ?>
        <tr>
            <td><strong>URL:</strong></td>
            <td style="display: flex; align-items: center; gap: 10px;">
                <a href="<?php echo htmlspecialchars($credential['url']); ?>" target="_blank" style="flex: 1; overflow: hidden; text-overflow: ellipsis;">
                    <?php echo htmlspecialchars($credential['url']); ?>
                </a>
                <button class="button" onclick="copyToClipboard('<?php echo htmlspecialchars($credential['url'], ENT_QUOTES); ?>')">Copy</button>
            </td>
        </tr>
        <?php endif; ?>

        <?php if (!empty($credential['tags'])): ?>
        <tr>
            <td><strong>Tags:</strong></td>
            <td><?php echo htmlspecialchars(implode(', ', $credential['tags'])); ?></td>
        </tr>
        <?php endif; ?>

        <?php if ($credential['folder']): ?>
        <tr>
            <td><strong>Folder:</strong></td>
            <td><?php echo htmlspecialchars($credential['folder']); ?></td>
        </tr>
        <?php endif; ?>

        <tr>
            <td><strong>Created:</strong></td>
            <td><?php echo htmlspecialchars(date('Y-m-d H:i:s', strtotime($credential['created_at']))); ?></td>
        </tr>

        <tr>
            <td><strong>Last Updated:</strong></td>
            <td><?php echo htmlspecialchars(date('Y-m-d H:i:s', strtotime($credential['updated_at']))); ?></td>
        </tr>
    </table>
</div>

<?php if ($credential['notes']): ?>
    <h2>Notes</h2>
    <div class="panel">
        <?php echo nl2br(htmlspecialchars($credential['notes'])); ?>
    </div>
<?php endif; ?>

<?php if (!isset($is_owner) || $is_owner): ?>
<h2 id="user-sharing">Share with User</h2>

<div class="panel">
    <p>
        <a href="/index.php?page=shares&action=share&id=<?php echo urlencode($credential['id']); ?>" class="button button-primary">Share with a Specific User</a>
    </p>
    <?php if (!empty($user_shares)): ?>
        <h3>Currently Shared With</h3>
        <table>
            <thead>
                <tr>
                    <th>User</th>
                    <th>Permissions</th>
                    <th>Shared On</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($user_shares as $us): ?>
                    <?php $recipientName = $share_user_map[$us['shared_with_user_id']] ?? $us['shared_with_user_id']; ?>
                    <tr>
                        <td><?php echo htmlspecialchars($recipientName); ?></td>
                        <td>
                            <?php
                            $perms = [];
                            if (!empty($us['permissions']['can_edit']))    $perms[] = 'Edit';
                            if (!empty($us['permissions']['can_reshare'])) $perms[] = 'Reshare';
                            echo $perms ? 'View, ' . implode(', ', $perms) : 'View';
                            ?>
                        </td>
                        <td><?php echo htmlspecialchars(date('Y-m-d H:i', strtotime($us['shared_at']))); ?></td>
                        <td><?php echo $us['revoked'] ? '<span style="color:red;">Revoked</span>' : '<span style="color:green;">Active</span>'; ?></td>
                        <td>
                            <?php if (!$us['revoked']): ?>
                                <form method="POST" action="/index.php?page=shares&action=revoke" style="display:inline;">
                                    <input type="hidden" name="csrf_token"     value="<?php echo htmlspecialchars($csrf_token ?? ''); ?>">
                                    <input type="hidden" name="share_id"       value="<?php echo htmlspecialchars($us['id']); ?>">
                                    <input type="hidden" name="credential_id"  value="<?php echo htmlspecialchars($credential['id']); ?>">
                                    <button type="submit" class="button" onclick="return confirm('Revoke access for <?php echo htmlspecialchars($recipientName, ENT_QUOTES); ?>?')">Revoke</button>
                                </form>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php else: ?>
        <p style="color:#666;">This credential has not been shared with any individual users yet.</p>
    <?php endif; ?>
</div>

<h2 id="public-sharing">Public Link Sharing</h2>

<div class="panel">
    <p>
        Generate a one-time link that anyone can open — <strong>no account required</strong>.
        The link self-destructs after the first view.
    </p>
    <form method="POST" action="/index.php?page=public-share&action=create" style="display:inline;">
        <input type="hidden" name="csrf_token"    value="<?php echo htmlspecialchars($csrf_token ?? ''); ?>">
        <input type="hidden" name="credential_id" value="<?php echo htmlspecialchars($credential['id']); ?>">
        <button type="submit" class="button" onclick="return confirm('Create a one-time public link for this credential?')">Create Public Link</button>
    </form>
    <a href="/index.php?page=public-share&action=list" class="button" style="margin-left:8px;">Manage Public Links</a>
</div>

<h2 id="group-sharing">Group Sharing</h2>

<?php if (!empty($user_groups)): ?>
    <div class="panel">
        <h3>Share with Group</h3>
        <form method="POST" action="/index.php?page=credentials&action=share-with-group">
            <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($csrf_token ?? ''); ?>">
            <input type="hidden" name="credential_id" value="<?php echo htmlspecialchars($credential['id']); ?>">

            <div class="form-group">
                <label for="group_id">Select Group:</label>
                <select id="group_id" name="group_id" required>
                    <option value="">-- Choose a Group --</option>
                    <?php foreach ($user_groups as $group): ?>
                        <option value="<?php echo htmlspecialchars($group['id']); ?>">
                            <?php echo htmlspecialchars($group['name']); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>

            <div class="form-group">
                <label for="permission">Permission Level:</label>
                <select id="permission" name="permission" required>
                    <option value="read">Read Only</option>
                    <option value="write">Read & Write</option>
                </select>
                <small>Read Only: Members can view the credential. Read & Write: Members can view and edit the credential.</small>
            </div>

            <button type="submit" class="button">Share with Group</button>
        </form>
    </div>

    <?php if (!empty($credential['shared_with_groups'])): ?>
        <div class="panel" style="margin-top: 20px;">
            <h3>Currently Shared With</h3>
            <table>
                <thead>
                    <tr>
                        <th>Group</th>
                        <th>Permission</th>
                        <th>Shared On</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($credential['shared_with_groups'] as $groupShare): ?>
                        <?php
                        // Find group name
                        $groupName = 'Unknown Group';
                        foreach ($user_groups as $group) {
                            if ($group['id'] === $groupShare['group_id']) {
                                $groupName = $group['name'];
                                break;
                            }
                        }
                        ?>
                        <tr>
                            <td><?php echo htmlspecialchars($groupName); ?></td>
                            <td>
                                <?php if ($groupShare['permission'] === 'write'): ?>
                                    <strong>Read & Write</strong>
                                <?php else: ?>
                                    Read Only
                                <?php endif; ?>
                            </td>
                            <td><?php echo htmlspecialchars(date('Y-m-d H:i', strtotime($groupShare['shared_at']))); ?></td>
                            <td>
                                <form method="POST" action="/index.php?page=credentials&action=revoke-group-share" style="display: inline;">
                                    <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($csrf_token ?? ''); ?>">
                                    <input type="hidden" name="credential_id" value="<?php echo htmlspecialchars($credential['id']); ?>">
                                    <input type="hidden" name="group_id" value="<?php echo htmlspecialchars($groupShare['group_id']); ?>">
                                    <button type="submit" class="button" onclick="return confirm('Revoke group access?')">Revoke</button>
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    <?php endif; ?>
<?php else: ?>
    <div class="alert alert-info">
        You are not a member of any groups. Join or create a group to share credentials with teams.
    </div>
<?php endif; ?>

<hr>

<h2>Delete Credential</h2>
<form method="POST" action="/index.php?page=credentials&action=delete" onsubmit="return confirm('Are you sure you want to delete this credential? This cannot be undone.');">
    <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($csrf_token ?? ''); ?>">
    <input type="hidden" name="id" value="<?php echo htmlspecialchars($credential['id']); ?>">
    <button type="submit" class="button" style="background: #ff0000; color: #fff;">Delete Credential</button>
</form>
<?php endif; ?>

<script>
function togglePasswordView() {
    var field = document.getElementById('password-field');
    var btn = document.getElementById('toggle-password-btn');
    var value = document.getElementById('password-value').value;
    if (field.textContent === '••••••••') {
        field.textContent = value;
        btn.textContent = 'Hide';
    } else {
        field.textContent = '••••••••';
        btn.textContent = 'Show';
    }
}
</script>
