<?php $title = 'Share Credential'; ?>

<h1>Share: <?php echo htmlspecialchars($credential['title'] ?? ''); ?></h1>

<?php if (isset($error) && $error): ?>
    <div class="alert alert-error">
        <?php echo htmlspecialchars($error); ?>
    </div>
<?php endif; ?>

<?php if (empty($recipients)): ?>
    <div class="alert alert-warning">
        <strong>No recipients available</strong><br>
        There are no other users in your groups to share with.
        Ask your administrator to add members to one of your groups.
    </div>
    <p><a href="/index.php?page=credentials&action=view&id=<?php echo urlencode($credential['id']); ?>" class="button">Back</a></p>
<?php else: ?>
    <div class="alert alert-info">
        The credential will be securely encrypted for the recipient.
        They will be able to view it from <strong>Shared Credentials</strong> without any extra steps.
    </div>

    <form method="POST" action="/index.php?page=shares&action=create">
        <input type="hidden" name="csrf_token"     value="<?php echo htmlspecialchars($csrf_token ?? ''); ?>">
        <input type="hidden" name="credential_id"  value="<?php echo htmlspecialchars($credential['id']); ?>">

        <div class="form-group">
            <label for="recipient_id">Share with:</label>
            <select id="recipient_id" name="recipient_id" required>
                <option value="">-- Select User --</option>
                <?php foreach ($recipients as $recipient): ?>
                    <option value="<?php echo htmlspecialchars($recipient['id']); ?>">
                        <?php echo htmlspecialchars($recipient['username'] . ' (' . $recipient['email'] . ')'); ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <fieldset>
            <legend>Permissions</legend>

            <div class="form-group">
                <label>
                    <input type="checkbox" checked disabled>
                    Can view (always enabled)
                </label>
            </div>

            <div class="form-group">
                <label>
                    <input type="checkbox" name="can_edit" value="1">
                    Can edit
                </label>
            </div>

            <div class="form-group">
                <label>
                    <input type="checkbox" name="can_reshare" value="1">
                    Can reshare with others
                </label>
            </div>
        </fieldset>

        <div class="form-group">
            <button type="submit" class="button button-primary">Share Credential</button>
            <a href="/index.php?page=credentials&action=view&id=<?php echo urlencode($credential['id']); ?>" class="button">Cancel</a>
        </div>
    </form>
<?php endif; ?>
