<?php $title = 'Credentials'; ?>

<div class="flex-between" style="margin-bottom: 20px;">
    <h1>My Credentials</h1>
    <a href="/index.php?page=credentials&action=create" class="button">New Credential</a>
</div>

<?php if (isset($success) && $success): ?>
    <div class="alert alert-success">
        <?php echo htmlspecialchars($success); ?>
    </div>
<?php endif; ?>

<?php if (isset($error) && $error): ?>
    <div class="alert alert-error">
        <?php echo htmlspecialchars($error); ?>
    </div>
<?php endif; ?>

<?php if (!empty($credentials)): ?>
    <table>
        <thead>
            <tr>
                <th>Title</th>
                <th>Type</th>
                <th>Username</th>
                <th>URL</th>
                <th>Access</th>
                <th>Updated</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($credentials as $cred): ?>
                <tr>
                    <td>
                        <strong><?php echo htmlspecialchars($cred['title']); ?></strong>
                        <?php if (isset($cred['is_owner']) && !$cred['is_owner']): ?>
                            <br><small style="color: #666;">(Shared via group)</small>
                        <?php endif; ?>
                        <?php if (isset($cred['is_owner']) && $cred['is_owner'] && !empty($cred['shared_group_names'])): ?>
                            <br><small style="color: #666; font-size: 10px;">
                                Shared with: <?php echo htmlspecialchars(implode(', ', $cred['shared_group_names'])); ?>
                            </small>
                        <?php endif; ?>
                    </td>
                    <td><?php echo htmlspecialchars($cred['type']); ?></td>
                    <td>
                        <?php if (!empty($cred['username'])): ?>
                            <?php echo htmlspecialchars($cred['username']); ?>
                            <button class="button" style="font-size: 10px; padding: 2px 6px;" onclick="copyToClipboard('<?php echo htmlspecialchars($cred['username'], ENT_QUOTES); ?>')">Copy</button>
                        <?php else: ?>
                            -
                        <?php endif; ?>
                        <?php if (!empty($cred['password'])): ?>
                            <button class="button" style="font-size: 10px; padding: 2px 6px; margin-left: 4px;" onclick="copyPassword('<?php echo htmlspecialchars($cred['id'], ENT_QUOTES); ?>')">Copy Pwd</button>
                        <?php endif; ?>
                    </td>
                    <td>
                        <?php if ($cred['url']): ?>
                            <a href="<?php echo htmlspecialchars($cred['url']); ?>" target="_blank">Link</a>
                            <button class="button" style="font-size: 10px; padding: 2px 6px;" onclick="copyToClipboard('<?php echo htmlspecialchars($cred['url'], ENT_QUOTES); ?>')">Copy</button>
                        <?php else: ?>
                            -
                        <?php endif; ?>
                    </td>
                    <td>
                        <?php
                        if (isset($cred['is_owner']) && $cred['is_owner']) {
                            echo '<strong>Owner</strong>';
                        } elseif (isset($cred['access_level'])) {
                            if ($cred['access_level'] === 'write') {
                                echo '<span style="color: green;">Read & Write</span>';
                            } else {
                                echo '<span style="color: #666;">Read Only</span>';
                            }
                        } else {
                            echo '-';
                        }
                        ?>
                    </td>
                    <td><?php echo htmlspecialchars(date('Y-m-d', strtotime($cred['updated_at']))); ?></td>
                    <td>
                        <a href="/index.php?page=credentials&action=view&id=<?php echo urlencode($cred['id']); ?>" class="button">View</a>
                        <?php if (isset($cred['is_owner']) && $cred['is_owner']): ?>
                            <a href="/index.php?page=credentials&action=view&id=<?php echo urlencode($cred['id']); ?>#sharing" class="button" title="Share with groups">Share</a>
                        <?php endif; ?>
                        <?php if (!isset($cred['is_owner']) || $cred['is_owner'] || (isset($cred['access_level']) && $cred['access_level'] === 'write')): ?>
                            <a href="/index.php?page=credentials&action=edit&id=<?php echo urlencode($cred['id']); ?>" class="button">Edit</a>
                        <?php endif; ?>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
<?php else: ?>
    <div class="alert alert-info">
        <strong>No credentials yet!</strong><br>
        Click "New Credential" to add your first password.
    </div>
<?php endif; ?>

<script>
function copyPassword(credentialId) {
    fetch('/index.php?page=credentials&action=get-password&id=' + encodeURIComponent(credentialId))
        .then(function(response) { return response.json(); })
        .then(function(data) {
            if (data.error) {
                showNotification(data.error, 'error');
                return;
            }
            copyToClipboard(data.password);
        })
        .catch(function() {
            showNotification('Failed to fetch password', 'error');
        });
}
</script>
