<?php $title = 'Edit Credential'; ?>

<h1>Edit Credential</h1>

<form method="POST" action="/index.php?page=credentials&action=update">
    <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($csrf_token ?? ''); ?>">
    <input type="hidden" name="id" value="<?php echo htmlspecialchars($credential['id']); ?>">
    <?php if (isset($owner_id)): ?>
    <input type="hidden" name="owner_id" value="<?php echo htmlspecialchars($owner_id); ?>">
    <?php endif; ?>

    <div class="form-group">
        <label for="title">Title: *</label>
        <input type="text" id="title" name="title" required autofocus
               value="<?php echo htmlspecialchars($credential['title']); ?>">
    </div>

    <div class="form-group">
        <label for="type">Type:</label>
        <select id="type" name="type">
            <option value="password" <?php echo $credential['type'] === 'password' ? 'selected' : ''; ?>>Password</option>
            <option value="note" <?php echo $credential['type'] === 'note' ? 'selected' : ''; ?>>Secure Note</option>
            <option value="card" <?php echo $credential['type'] === 'card' ? 'selected' : ''; ?>>Credit Card</option>
            <option value="identity" <?php echo $credential['type'] === 'identity' ? 'selected' : ''; ?>>Identity</option>
        </select>
    </div>

    <div class="form-group">
        <label for="username">Username:</label>
        <input type="text" id="username" name="username"
               value="<?php echo htmlspecialchars($credential['username'] ?? ''); ?>">
    </div>

    <div class="form-group">
        <label for="password">Password:</label>
        <div class="flex gap-10">
            <input type="password" id="password" name="password" style="flex: 1;"
                   placeholder="Leave blank to keep current password">
            <button type="button" class="button" onclick="togglePassword('password')">Show</button>
            <button type="button" class="button" onclick="generatePassword()">Generate</button>
        </div>
        <small>Leave blank to keep the current password</small>
    </div>

    <div class="form-group">
        <label for="url">URL:</label>
        <input type="url" id="url" name="url"
               value="<?php echo htmlspecialchars($credential['url'] ?? ''); ?>">
    </div>

    <div class="form-group">
        <label for="tags">Tags:</label>
        <input type="text" id="tags" name="tags"
               value="<?php echo htmlspecialchars(implode(', ', $credential['tags'] ?? [])); ?>">
    </div>

    <div class="form-group">
        <label for="folder">Folder:</label>
        <input type="text" id="folder" name="folder"
               value="<?php echo htmlspecialchars($credential['folder'] ?? ''); ?>">
    </div>

    <div class="form-group">
        <label for="notes">Notes:</label>
        <textarea id="notes" name="notes" rows="4"><?php echo htmlspecialchars($credential['notes'] ?? ''); ?></textarea>
    </div>

    <div class="form-group">
        <button type="submit" class="button button-primary">Update Credential</button>
        <a href="/index.php?page=credentials&action=view&id=<?php echo urlencode($credential['id']); ?>" class="button">Cancel</a>
    </div>
</form>
