<?php $title = 'New Credential'; ?>

<h1>Create New Credential</h1>

<form method="POST" action="/index.php?page=credentials&action=store">
    <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($csrf_token ?? ''); ?>">

    <div class="form-group">
        <label for="title">Title: *</label>
        <input type="text" id="title" name="title" required autofocus placeholder="e.g., Gmail Account">
    </div>

    <div class="form-group">
        <label for="type">Type:</label>
        <select id="type" name="type">
            <option value="password">Password</option>
            <option value="note">Secure Note</option>
            <option value="card">Credit Card</option>
            <option value="identity">Identity</option>
        </select>
    </div>

    <div class="form-group">
        <label for="username">Username:</label>
        <input type="text" id="username" name="username" placeholder="e.g., user@example.com">
    </div>

    <div class="form-group">
        <label for="password">Password:</label>
        <div class="flex gap-10">
            <input type="password" id="password" name="password" style="flex: 1;">
            <button type="button" class="button" onclick="togglePassword('password')">Show</button>
            <button type="button" class="button" onclick="generatePassword()">Generate</button>
        </div>
    </div>

    <div class="form-group">
        <label for="url">URL:</label>
        <input type="url" id="url" name="url" placeholder="https://example.com">
    </div>

    <div class="form-group">
        <label for="tags">Tags:</label>
        <input type="text" id="tags" name="tags" placeholder="Comma separated: work, email, important">
    </div>

    <div class="form-group">
        <label for="folder">Folder:</label>
        <input type="text" id="folder" name="folder" placeholder="e.g., Work, Personal">
    </div>

    <div class="form-group">
        <label for="notes">Notes:</label>
        <textarea id="notes" name="notes" rows="4" placeholder="Additional information..."></textarea>
    </div>

    <?php if (!empty($user_groups)): ?>
    <div class="form-group">
        <label for="group_ids">Share with Groups:</label>
        <select id="group_ids" name="group_ids[]" multiple style="height: auto; min-height: 60px;">
            <?php foreach ($user_groups as $group): ?>
                <option value="<?php echo htmlspecialchars($group['id']); ?>">
                    <?php echo htmlspecialchars($group['name']); ?>
                </option>
            <?php endforeach; ?>
        </select>
        <small>Hold Ctrl/Cmd to select multiple groups. Leave unselected to keep private.</small>
    </div>

    <div class="form-group">
        <label for="group_permission">Group Permission Level:</label>
        <select id="group_permission" name="group_permission">
            <option value="read">Read Only</option>
            <option value="write">Read & Write</option>
        </select>
        <small>Permission level for all selected groups above.</small>
    </div>
    <?php endif; ?>

    <div class="form-group">
        <button type="submit" class="button button-primary">Save Credential</button>
        <a href="/index.php?page=credentials" class="button">Cancel</a>
    </div>
</form>
