<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>PassGram v3.0 - Register</title>
    <link rel="stylesheet" href="/assets/css/style.css">
</head>
<body>
    <div class="window window-medium">
        <div class="title-bar">
            <span class="title-bar-text">PassGram v3.0 - Register</span>
        </div>
        <div class="window-body">
            <h1>Register for PassGram</h1>

            <div class="alert alert-info">
                <strong>Invite-Only Registration</strong><br>
                You need a valid invite code to register. Contact your group administrator to get one.
            </div>

            <?php if (isset($error) && $error): ?>
                <div class="alert alert-error">
                    <?php echo htmlspecialchars($error); ?>
                </div>
            <?php endif; ?>

            <form method="POST" action="/register.php">
                <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($csrf_token ?? ''); ?>">

                <div class="form-group">
                    <label for="invite_code">Invite Code:</label>
                    <input type="text" id="invite_code" name="invite_code" required autofocus
                           value="<?php echo htmlspecialchars($invite_code ?? ''); ?>"
                           placeholder="64 character invite code">
                </div>

                <div class="form-group">
                    <label for="username">Username:</label>
                    <input type="text" id="username" name="username" required
                           placeholder="3-32 characters, letters/numbers/underscore">
                </div>

                <div class="form-group">
                    <label for="email">Email:</label>
                    <input type="email" id="email" name="email" required>
                </div>

                <div class="form-group">
                    <label for="password">Password:</label>
                    <input type="password" id="password" name="password" required
                           placeholder="Enter your password">
                </div>

                <div class="form-group">
                    <label for="confirm_password">Confirm Password:</label>
                    <input type="password" id="confirm_password" name="confirm_password" required>
                </div>

                <div class="form-group">
                    <button type="submit" class="button button-primary">Register</button>
                </div>
            </form>

            <hr>

            <p>Already have an account? <a href="/login.php">Login</a></p>
        </div>
    </div>
</body>
</html>
