<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>PassGram v3.0 - Login</title>
    <link rel="stylesheet" href="/assets/css/style.css">
</head>
<body>
    <div class="window window-medium">
        <div class="title-bar">
            <span class="title-bar-text">PassGram v3.0 - Login</span>
        </div>
        <div class="window-body">
            <h1>Login to PassGram</h1>

            <?php if (isset($error) && $error): ?>
                <div class="alert alert-error">
                    <?php echo htmlspecialchars($error); ?>
                </div>
            <?php endif; ?>

            <?php if (isset($success) && $success): ?>
                <div class="alert alert-success">
                    <?php echo htmlspecialchars($success); ?>
                </div>
            <?php endif; ?>

            <form method="POST" action="/login.php">
                <?php echo $csrf_token_field ?? ''; ?>
                <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($csrf_token ?? ''); ?>">

                <div class="form-group">
                    <label for="username">Username:</label>
                    <input type="text" id="username" name="username" required autofocus>
                </div>

                <div class="form-group">
                    <label for="password">Password:</label>
                    <input type="password" id="password" name="password" required>
                </div>

                <div class="form-group">
                    <button type="submit" class="button button-primary">Login</button>
                </div>
            </form>

            <hr>

            <p>Don't have an account? <a href="/register.php">Register with an invite code</a></p>
            <p>Browse the <a href="/index.php?page=keys">Public PGP Key Directory</a></p>
        </div>
    </div>
</body>
</html>
