<?php

namespace PassGram\Controllers;

use PassGram\Core\Database;

/**
 * PublicKeyController
 *
 * Serves the unauthenticated public PGP key directory.
 * Reads from the shared public catalog; never touches per-user files.
 */
class PublicKeyController
{
    private Database $db;

    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    /**
     * Render the public key directory page.
     */
    public function index(): void
    {
        try {
            $catalog = $this->db->readPublicPGPKeyCatalog();
            $keys    = $catalog['keys'] ?? [];

            // Sort newest-first
            usort($keys, function ($a, $b) {
                return strcmp($b['updated_at'], $a['updated_at']);
            });

        } catch (\Exception $e) {
            $keys = [];
        }

        $data = ['keys' => $keys];

        extract($data);
        require __DIR__ . '/../Views/public/keys.php';
    }
}
