<?php

namespace PassGram\Controllers;

use PassGram\Core\Session;
use PassGram\Security\Auth;
use PassGram\Security\CSRF;
use PassGram\Models\Note;
use PassGram\Helpers\Sanitizer;

class NoteController
{
    private Auth $auth;
    private CSRF $csrf;
    private Note $noteModel;

    public function __construct(
        Auth $auth,
        CSRF $csrf,
        Note $noteModel
    ) {
        $this->auth = $auth;
        $this->csrf = $csrf;
        $this->noteModel = $noteModel;

        // Require authentication
        if (!$this->auth->check()) {
            header('Location: /login.php');
            exit;
        }
    }

    public function index(): void
    {
        $userId = $this->auth->getUserId();
        $user = $this->auth->getCurrentUser();
        $encryptionKey = substr($user['master_key_hash'], 0, 32);

        // For now, just show a basic notes list page
        $data = [
            'csrf_token' => $this->csrf->getToken(),
            'success' => Session::flash('success'),
            'error' => Session::flash('error'),
        ];

        $this->render('notes/index', $data);
    }

    private function render(string $view, array $data = []): void
    {
        extract($data);
        require __DIR__ . '/../Views/layouts/header.php';
        require __DIR__ . '/../Views/' . $view . '.php';
        require __DIR__ . '/../Views/layouts/footer.php';
    }
}
