<?php
/**
 * PassGram v3.0 - Logout Handler
 */

require_once __DIR__ . '/autoload.php';

use PassGram\Core\Config;
use PassGram\Core\Session;
use PassGram\Core\Database;
use PassGram\Security\Auth;
use PassGram\Security\CSRF;
use PassGram\Security\Encryption;
use PassGram\Models\User;
use PassGram\Models\Group;
use PassGram\Models\Invite;
use PassGram\Helpers\Validator;
use PassGram\Helpers\Logger;
use PassGram\Controllers\AuthController;

$config = Config::getInstance(__DIR__ . '/config');

if (!$config->isInstalled() || !file_exists(__DIR__ . '/data/users.json.enc')) {
    header('Location: /install.php');
    exit;
}

// Start session
Session::start();

$masterKey = hex2bin($config->get('security.master_application_key'));
$encryption = new Encryption($masterKey, $config->get('security.encryption'));
$db = new Database($encryption, $config->database());

$csrf = new CSRF();
$validator = new Validator($config);
$logger = new Logger($config->get('database.activity_log'));

$userModel = new User($db, $config, $validator);
$groupModel = new Group($db, $validator);
$inviteModel = new Invite($db, $config, $validator);
$auth = new Auth($db, $config, $logger);

$controller = new AuthController($config, $db, $auth, $csrf, $userModel, $groupModel, $inviteModel, $validator, $logger);
$controller->logout();
