<?php
/**
 * PassGram v3.0 - Security Configuration
 *
 * Generated during installation. Keep this file backed up in a secure location.
 * If the master_application_key is ever lost, all encrypted data is unrecoverable.
 */

return [

    // Master Application Key (MAK) — set by install.php during first run
    'master_application_key' => 'REPLACE_WITH_GENERATED_KEY_DURING_INSTALLATION',

    // AES-256-GCM settings used by the Encryption class
    'encryption' => [
        'algorithm'  => 'aes-256-gcm',
        'key_length' => 32,     // bytes
        'iv_length'  => 12,     // bytes (96-bit nonce, recommended for GCM)
        'tag_length' => 16,     // bytes (128-bit authentication tag)
    ],

    // Argon2id parameters for key derivation (PGP private-key passphrase)
    'argon2' => [
        'memory_cost' => 65536,     // KB (64 MB)
        'time_cost'   => 4,         // iterations
        'threads'     => 2,
    ],

    // bcrypt cost factor for password hashing
    'bcrypt_cost' => 12,

];
