<?php
/**
 * PassGram v3.0 - Database Configuration
 *
 * This file defines the paths to all encrypted JSON database files.
 * All paths are outside the web root for security.
 */

$dataPath = dirname(__DIR__) . '/data';

return [
    // Main database files
    'users' => $dataPath . '/users.json.enc',
    'groups' => $dataPath . '/groups.json.enc',
    'invites' => $dataPath . '/invites.json.enc',
    'pgpkeys_public' => $dataPath . '/pgpkeys/public_catalog.json.enc',

    // Directory paths for per-entity files
    'credentials_dir' => $dataPath . '/credentials',
    'pgpkeys_dir' => $dataPath . '/pgpkeys',
    'shares_dir' => $dataPath . '/shares',
    'public_shares_dir' => $dataPath . '/public_shares',
    'notes_dir' => $dataPath . '/notes',
    'pgp_dir' => $dataPath . '/pgp',

    // Specific note files
    'user_notes' => $dataPath . '/notes/user_notes.json.enc',
    'credential_notes' => $dataPath . '/notes/credential_notes.json.enc',

    // Log files
    'activity_log' => $dataPath . '/logs/activity.log',
    'error_log' => $dataPath . '/logs/error.log',

    // File permissions
    'permissions' => [
        'files' => 0600, // rw-------
        'directories' => 0700, // rwx------
    ],

    // Default data structures
    'defaults' => [
        'users' => ['users' => []],
        'groups' => ['groups' => []],
        'invites' => ['invites' => []],
        'user_notes' => ['notes' => []],
        'credential_notes' => ['notes' => []],
        'credentials' => [
            'user_id' => null,
            'credentials' => []
        ],
        'pgpkeys' => [
            'user_id' => null,
            'keys' => []
        ],
        'pgpkeys_public' => [
            'keys' => []
        ],
    ],
];
