<?php
/**
 * PassGram v3.0 - Application Configuration
 *
 * Generated during installation.
 * Edit base_url and set cookie_secure to true before deploying to production.
 */

return [

    'name'     => 'PassGram',
    'version'  => '3.0',
    'base_url' => '',        // e.g. https://your-domain.com  (no trailing slash)
    'debug'    => false,

    // Session settings
    'session' => [
        'timeout'         => 3600,              // seconds (60 minutes)
        'name'            => 'passgram_session',
        'cookie_secure'   => false,             // set true when serving over HTTPS
        'cookie_httponly' => true,
        'cookie_samesite' => 'Strict',
    ],

    // Input validation / security rules
    'security' => [
        'password_min_length' => 12,
        'username_min_length' => 3,
        'username_max_length' => 32,
        'max_login_attempts'  => 5,
        'lockout_duration'    => 900,           // seconds (15 minutes)
        'invite_expiry_days'  => 7,
    ],

    // Filesystem paths used at runtime
    'paths' => [
        'pgp' => dirname(__DIR__) . '/data/pgp',
    ],

];
