<?php
/**
 * PassGram v3.0 - Autoloader
 *
 * Simple PSR-4 compatible autoloader for PassGram.
 * No Composer required - just upload and run!
 */

spl_autoload_register(function ($class) {
    // Project namespace
    $prefix = 'PassGram\\';

    // Base directory for the namespace prefix
    $baseDir = __DIR__ . '/src/';

    // Does the class use the namespace prefix?
    $len = strlen($prefix);
    if (strncmp($prefix, $class, $len) !== 0) {
        // No, move to the next registered autoloader
        return;
    }

    // Get the relative class name
    $relativeClass = substr($class, $len);

    // Replace namespace separators with directory separators
    // and append .php
    $file = $baseDir . str_replace('\\', '/', $relativeClass) . '.php';

    // If the file exists, require it
    if (file_exists($file)) {
        require $file;
    }
});
