# PassGram v3.0

**Secure Password Manager with PGP Key Store, Public Key Directory, Group Collaboration & Per-User PGP Encryption Mode**

PassGram is a standalone PHP password manager featuring group-based credential sharing, a PGP public key store with optional public directory listing, PGP encryption using native PHP OpenSSL, encrypted JSON file storage, and an invite-only registration system. All styled with an authentic OS/2 Warp 3.0 interface with purple title bars.

## Features

### Core Functionality
- **Encrypted Password Storage** - AES-256-GCM encryption for all credentials
- **Group Collaboration** - Users belong to groups and can share credentials and PGP keys
- **Complete Group Management** - Create, edit, delete groups, add/remove members, transfer ownership
- **Group-Level Credential Sharing** - Share credentials with entire groups (read-only or read/write permissions)
- **PGP Key Store** - Import, store, and share public PGP keys with groups (just like credentials)
- **Public PGP Key Directory** - Optionally list public keys in an unauthenticated searchable directory
- **PGP Key Management** - Generate RSA, DSA, or Elliptic Curve keys with configurable sizes
- **Cross-User Credential Access** - Group members can view and edit shared credentials across user boundaries
- **Copy Password from List** - Copy passwords to clipboard directly from the credential list via AJAX
- **Group Assignment at Creation** - Assign credentials and PGP keys to groups at creation time
- **Credential Sharing** - Share passwords with group members using PGP encryption
- **Invite-Only Registration** - Secure invite codes tied to specific groups
- **Notes System** - Add notes to users (group-visible) and credentials (private)
- **Multi-Field Credentials** - Store passwords, usernames, URLs, custom fields, tags
- **Password Generator** - Built-in secure random password generator
- **Copy-to-Clipboard** - One-click copying for credentials, invites, URLs, PGP keys, and fingerprints
- **Persistent Navigation** - Dashboard menu accessible on all pages when logged in

### PGP Key Store (Added in v2.0)
- **Import Public Keys** - Paste PEM-encoded public keys (RSA, DSA, EC)
- **Key Metadata** - Label, owner name, owner email, fingerprint, algorithm, key bits
- **Group Sharing** - Share PGP keys with groups, same pattern as credential sharing
- **Cross-User Access** - Group members can view keys shared by other users
- **Public Directory Listing** - Optionally make keys visible to unauthenticated visitors
- **Search & Filter** - Client-side search by name, email, label, or fingerprint
- **Copy to Clipboard** - Copy full public key text or fingerprint with one click
- **Download Keys** - Download public keys as .pem files

### Public PGP Key Directory (Added in v2.0)
- **Unauthenticated Access** - No login required to browse publicly listed keys
- **Search & Filter** - Real-time client-side filtering by name, email, label, or fingerprint
- **Copy Key** - Copy the full PGP public key to clipboard
- **Copy Fingerprint** - Copy key fingerprint to clipboard
- **Privacy Controls** - Only owner name, email, label, fingerprint, algorithm, and public key are exposed; notes, tags, and group info are never published
- **Accessible from Login Page** - Link on the login page for easy discovery

### Security Features
- **Master Application Key (MAK)** - Encrypts all JSON database files
- **User Master Password** - Never stored, only hashed (bcrypt + Argon2id)
- **Field-Level Encryption** - Sensitive credential fields encrypted individually
- **PGP Public Key Cryptography** - For secure credential sharing between users
- **CSRF Protection** - All state-changing operations protected
- **Rate Limiting** - Brute force protection on authentication
- **Session Security** - Secure, httponly, samesite cookies
- **Comprehensive Logging** - Audit trail of all security events

### User Interface
- **OS/2 Warp 3.0 Theme** - Authentic purple title bars (#5D009D), beveled borders, classic gray backgrounds
- **Server-Side Rendered** - Traditional PHP approach, works without JavaScript
- **Enhanced User Experience** - Copy buttons, show/hide passwords, dynamic forms
- **Responsive Design** - Works on desktop and mobile devices

## System Requirements

- **PHP 7.4+** (PHP 8.x recommended)
- **OpenSSL Extension** (standard on all servers)
- **JSON Extension** (standard on all servers)
- **Writable `data/` directory** for encrypted storage
- **HTTPS** (required for production - configured in web server)

## Installation

### 1. Upload Files

Transfer all PassGram files to your web server. The `public/` directory should be your web root.

```
your-domain.com/
├── public/          <- Point your web server here
├── src/
├── data/
├── config/
├── autoload.php
└── install.php
```

### 2. Set Permissions

```bash
chmod 700 data/
chmod 700 config/
chmod 644 public/.htaccess
```

### 3. Run Installation

Visit `https://your-domain.com/install.php` in your browser.

The installer will:
- Generate a secure Master Application Key (MAK)
- Create the first admin user
- Create a default group
- Generate an invite code for additional users
- Initialize the encrypted database

**IMPORTANT:**
- Save the invite code displayed after installation
- Backup `config/security.php` to a secure location
- Delete `install.php` after successful installation

### 4. Configure Web Server

**Apache (.htaccess already included):**
Point DocumentRoot to `/public/` directory.

**Nginx:**
```nginx
server {
    listen 443 ssl;
    server_name your-domain.com;

    root /path/to/passgram/v3.0/public;
    index index.php;

    location / {
        try_files $uri $uri/ /index.php?$query_string;
    }

    location ~ \.php$ {
        fastcgi_pass unix:/var/run/php/php8.1-fpm.sock;
        fastcgi_index index.php;
        include fastcgi_params;
    }

    # Block access to sensitive directories
    location ~ ^/(config|data|src)/ {
        deny all;
    }
}
```

### 5. Update Configuration

Edit `config/config.php`:
- Set `base_url` to your domain
- Enable `cookie_secure` when using HTTPS
- Adjust security settings as needed

## Directory Structure

```
v3.0/
├── autoload.php                 # Standalone PSR-4 autoloader
├── install.php                  # Installation script (delete after install)
├── public/                      # Web root
│   ├── index.php               # Main entry point & router
│   ├── login.php               # Login page
│   ├── logout.php              # Logout handler
│   ├── register.php            # Invite-based registration
│   ├── assets/
│   │   ├── css/style.css       # OS/2 Warp 3.0 theme
│   │   └── js/app.js           # Client-side interactions
│   └── .htaccess               # Apache security & rewrite rules
├── src/                         # Application code
│   ├── Core/                   # Core infrastructure
│   │   ├── Config.php          # Configuration loader
│   │   ├── Database.php        # Encrypted JSON file operations (AES + PGP mode)
│   │   └── Session.php         # Secure session management
│   ├── Security/               # Security components
│   │   ├── Encryption.php      # AES-256-GCM encryption
│   │   ├── PGP.php             # Native PHP OpenSSL RSA/DSA/EC key generation
│   │   ├── PGPEncryption.php   # Hybrid RSA+AES-256-GCM per-user encryption (v3.0)
│   │   ├── Auth.php            # Authentication
│   │   └── CSRF.php            # CSRF protection
│   ├── Models/                 # Data models
│   │   ├── User.php            # User management + PGP encryption mode setting
│   │   ├── Group.php           # Group management
│   │   ├── Invite.php          # Invite code system
│   │   ├── Credential.php      # Password storage + cross-user access
│   │   ├── PGPKey.php          # PGP key store + public catalog sync
│   │   ├── Share.php           # PGP-encrypted sharing
│   │   └── Note.php            # Notes system
│   ├── Controllers/            # Request handlers
│   │   ├── AuthController.php
│   │   ├── DashboardController.php
│   │   ├── CredentialController.php
│   │   ├── GroupController.php
│   │   ├── InviteController.php
│   │   ├── PGPController.php         # Key generation + encryption mode toggle (v3.0)
│   │   ├── PGPKeyController.php      # Key Store CRUD + group sharing
│   │   ├── PublicKeyController.php   # Unauthenticated public directory
│   │   ├── ShareController.php
│   │   └── NoteController.php
│   ├── Views/                  # PHP templates
│   │   ├── layouts/            # header.php, footer.php, navigation.php
│   │   ├── auth/               # login.php, register.php
│   │   ├── dashboard/          # index.php
│   │   ├── credentials/        # list, view, create, edit
│   │   ├── pgpkeys/            # list, view, create, edit
│   │   ├── public/             # keys.php (unauthenticated directory)
│   │   ├── groups/             # list, view, create, edit
│   │   ├── invites/            # list
│   │   ├── pgp/                # view (with encryption mode toggle), generate
│   │   └── shares/             # list, view
│   └── Helpers/                # Utility classes
│       ├── Validator.php       # Input validation
│       ├── Sanitizer.php       # XSS prevention
│       └── Logger.php          # Activity logging
├── data/                        # Encrypted storage (outside web root)
│   ├── users.json.enc          # Encrypted user database
│   ├── groups.json.enc         # Encrypted groups
│   ├── invites.json.enc        # Encrypted invites
│   ├── credentials/            # Per-user credential files
│   │   ├── {userId}.json.enc   #   AES mode  – master application key
│   │   └── {userId}.pgp.enc    #   PGP mode  – user's own RSA/EC key pair
│   ├── pgpkeys/                # Per-user PGP public-key stores
│   │   ├── {userId}.json.enc   #   AES mode  – master application key
│   │   ├── {userId}.json       #   PGP mode  – plain JSON (public keys need no encryption)
│   │   └── public_catalog.json.enc  # Shared public key catalog
│   ├── shares/                 # Shared credential metadata
│   ├── notes/                  # Notes storage
│   ├── pgp/                    # Personal PGP key pairs
│   │   ├── {userId}_public.key     # PEM public key
│   │   └── {userId}_private.key.enc # Passphrase-protected private key
│   └── logs/                   # Activity logs
└── config/                      # Configuration files
    ├── config.php              # Main configuration
    ├── database.php            # Storage paths
    └── security.php            # Master key & crypto settings
```

## Usage

### First Steps

1. **Login** with admin credentials created during installation
2. **Generate PGP Keys** (My PGP -> Generate)
   - Choose encryption algorithm (RSA recommended)
   - Select key size (4096 bits for maximum security)
   - Or choose Elliptic Curve for modern cryptography
3. **Add Credentials** (Dashboard -> New Credential)
   - Optionally assign to groups at creation time
4. **Import PGP Keys** (Key Store -> Import PGP Key)
   - Optionally list in public directory
5. **Create Groups** (Groups -> Create Group)
6. **Invite Users** (Invites -> Generate Invite Code)
7. **Share Credentials** (Credential -> Share with Group)

### Credential Types

PassGram supports multiple credential types:
- **Password** - Standard login credentials
- **Note** - Secure notes
- **Card** - Credit card information
- **Identity** - Personal information

### Sharing Credentials with Groups

1. Navigate to the credential
2. Scroll to "Group Sharing" section
3. Select a group from the dropdown
4. Choose permission level:
   - **Read Only** - Members can view the credential
   - **Read & Write** - Members can view and edit the credential
5. Click "Share with Group"

All group members will immediately have access to the credential based on their permission level.

### PGP Key Store

1. Navigate to **Key Store** in the navigation
2. Click **Import PGP Key**
3. Fill in label, owner name, owner email
4. Paste the PEM-encoded public key
5. Optionally check **"List this key in the public directory"**
6. Optionally select groups to share with
7. Click **Store PGP Key**

### Public PGP Key Directory

- Accessible at `/index.php?page=keys` without logging in
- Linked from the login page
- Search by name, email, label, or fingerprint using the search box
- Click **Copy Key** to copy the full public key to clipboard
- Click **Copy FP** to copy the fingerprint

### Managing Groups

As a group owner, you can:

1. **Add Members** - Enter username to add existing users
2. **Remove Members** - Click "Remove" next to member name
3. **Transfer Ownership** - Select new owner from dropdown
4. **Edit Group** - Change name and description
5. **Delete Group** - Permanently remove group (with confirmation)

### PGP Key Options

When generating PGP keys, choose from multiple encryption algorithms:

**RSA (Recommended)**
- Most widely compatible
- Key sizes: 2048, 3072, or 4096 bits
- Best for general use

**DSA (Legacy)**
- For compatibility with older systems
- Limited to signing operations
- Not recommended for new deployments

**Elliptic Curve (Modern)**
- Strong security with smaller keys
- Curves: secp384r1 (recommended), secp521r1 (maximum), prime256v1
- May have compatibility issues with older systems

## Security Considerations

### Master Application Key (MAK)
- Generated during installation
- Encrypts all JSON database files
- **Never change it** - all data becomes unrecoverable
- Backup `config/security.php` securely offline

### User Master Password
- Used for authentication (bcrypt hash)
- Derives encryption key for PGP private key (Argon2id)
- **Never stored** - only hashes stored
- Cannot be recovered if forgotten

### Public Key Directory
- Only voluntarily published data is shown (owner must check the "public" box)
- Notes, tags, and group sharing info are never exposed
- The public catalog is a separate encrypted file synced on create/edit/delete
- Public keys are inherently public data - no sensitive information is leaked

### HTTPS
**Always use HTTPS in production.** Password managers should never run over HTTP.

### Backups
Backup these regularly:
- `config/security.php` - Contains MAK
- `data/` directory - All encrypted data

## Technical Details

### No Dependencies
PassGram is completely standalone:
- **No Composer** required
- **No external libraries**
- Uses native PHP OpenSSL for RSA/PGP operations
- Simple PSR-4 autoloader included

### Encryption Architecture

**Layer 1: Master Application Key**
- Encrypts all JSON database files
- AES-256-GCM algorithm

**Layer 2: User Master Password**
- Hashed with bcrypt for authentication
- Hashed with Argon2id for key derivation
- Never stored in plain text

**Layer 3: PGP Encryption**
- Multiple algorithms: RSA (2048/3072/4096 bits), DSA, Elliptic Curve
- Used for credential sharing between users
- Private keys encrypted with user's PGP passphrase (AES-256-GCM + Argon2id)
- Native PHP OpenSSL implementation

**Layer 3b: PGP Encryption Mode (v3.0)**
- Optional per-user switch to encrypt credential and key-store files with the user's own key pair instead of the master application key
- Hybrid RSA+AES-256-GCM: random session key wrapped with user's public key
- Passphrase stored in server-side session only; cleared on logout
- Credentials: `{userId}.pgp.enc` | Public keys: `{userId}.json` (plain)

**Layer 4: Field-Level Encryption**
- Sensitive credential fields encrypted individually
- AES-256-GCM with random IV per field

### Data Storage
All data stored in encrypted JSON files:
- No SQL database required
- Atomic write operations
- File locking for concurrent access
- Per-user credential and PGP key files for scalability
- Public key catalog synced automatically on create/edit/delete

## Known Limitations

- **No Database** - Uses encrypted JSON files instead of SQL (intentional design choice)
- **Single Server** - Not designed for distributed/clustered deployments
- **File-Based Sessions** - PHP session files (can be configured for Redis/Memcached)
- **No Email** - Invite codes must be shared manually (no email sending)
- **No 2FA** - Two-factor authentication not yet implemented
- **No API** - Web interface only, no REST API

## Browser Compatibility

- Modern browsers (Chrome, Firefox, Safari, Edge)
- JavaScript optional but recommended for enhanced UX
- Copy-to-clipboard requires modern browser with Clipboard API or execCommand support

## License

PassGram v3.0 - Copyright 2025-2026 Jason Page / Amfile.org

## Developer

Developed by **Jason Page** of [Amfile.org](https://amfile.org).

For issues, questions, or contributions, please contact the developer.

---

**PassGram v3.0** - Secure. Simple. Standalone.
