# Changelog

All notable changes to PassGram will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [3.0] - 2026-02-25

### Added

#### Per-User PGP Encryption Mode
- **PGP Encryption Mode Toggle** - Switch per-user credential and public-key storage from the shared master application key to the user's own PGP key pair
- **Hybrid RSA+AES-256-GCM** - New `PGPEncryption` class encrypts a random 256-bit AES session key with the user's RSA/EC public key (OAEP padding), then encrypts data with AES-256-GCM; bundle stored as base64-encoded JSON envelope
- **Session Passphrase Unlock** - User enters PGP passphrase once per session; verified against stored private key blob and held server-side in `$_SESSION['pgp_passphrase']`; cleared on logout
- **Lock/Unlock Controls** - Explicit lock button to clear passphrase from session; unlock form to re-enter it
- **Data Migration** - Toggle action migrates existing files between formats: AES `.json.enc` ↔ PGP `.pgp.enc` (credentials) and AES `.json.enc` ↔ plain `.json` (public keys); old file deleted on success
- **User-ID-Scoped Context** - PGP context is owner-ID-aware so other users' files (e.g. group-shared credentials) are always read/written in AES mode, preserving group sharing functionality
- **Passphrase Verification** - `PGPEncryption::verifyPassphrase()` validates passphrase before storing in session

#### New Storage Formats (PGP mode)
- `data/credentials/{userId}.pgp.enc` - RSA+AES-256-GCM encrypted credentials file
- `data/pgpkeys/{userId}.json` - Plain JSON public-key store (public keys need no encryption)

### Changed
- **Version strings** - Updated all title bars, page titles, PHP comments, config version field, and asset headers from v2.50/v2.00 to v3.0
- **`src/Core/Database.php`** - Added `setPGPContext()`, `clearPGPContext()`, `hasPGPContext()`, `pgpContextAppliesTo()`, PGP-mode read/write helpers, and migration methods
- **`src/Models/User.php`** - Added `setPGPEncryptionMode(userId, bool)` to toggle `settings.pgp_encryption_mode`
- **`src/Controllers/PGPController.php`** - Added `unlockPGP()`, `lockPGP()`, `toggleEncryption()` actions
- **`src/Views/pgp/view.php`** - Added encryption mode section with passphrase unlock form, mode toggle button, and storage format reference table
- **`index.php`** - Added PGP context injection block after auth check; added routes `unlock-pgp`, `lock-pgp`, `toggle-encryption`
- **`config/config.php`** - `version` key updated to `'3.0'`

### New Files
- `src/Security/PGPEncryption.php` - Hybrid RSA+AES-256-GCM encryption class with `encrypt()`, `decrypt()`, `encryptData()`, `decryptData()`, `verifyPassphrase()`

---

## [2.00] - 2026-02-13

### Added

#### PGP Key Store
- **Import Public Keys** - Paste PEM-encoded public keys (RSA, DSA, EC) into a personal key store
- **Key Metadata** - Store label, owner name, owner email with auto-extracted fingerprint, algorithm, and key bits
- **Group Sharing** - Share PGP keys with groups using the same pattern as credential sharing (read-only or read/write)
- **Cross-User Key Access** - Group members can view keys shared by other users across user boundaries
- **Tags & Notes** - Attach tags and private notes to stored keys
- **Full CRUD** - Create, view, edit, and delete stored PGP keys
- **Copy & Download** - Copy public key text or fingerprint to clipboard; download keys as .pem files

#### Public PGP Key Directory
- **Unauthenticated Access** - Browse publicly listed keys without logging in (`/index.php?page=keys`)
- **Opt-In Public Listing** - Key owners toggle "List this key in the public directory" checkbox on create/edit
- **Real-Time Search** - Client-side filtering by name, email, label, or fingerprint
- **Copy Key** - Copy the full PGP public key text to clipboard from the directory
- **Copy Fingerprint** - Copy key fingerprint to clipboard
- **Privacy Controls** - Only safe fields published (label, owner name, email, fingerprint, algorithm, key bits, public key text); notes, tags, and group info are never exposed
- **Shared Catalog** - Efficient `public_catalog.json.enc` file synced automatically on create/edit/delete; public page never touches per-user files
- **Login Page Link** - Directory linked from the login page for easy discovery

#### Cross-User Credential Access (ported from v1.02)
- **`findByIdAcrossUsers()`** - Group members can now view and edit credentials owned by other users when shared via groups
- **Ownership-Aware UI** - Credential view page shows access level (read-only/read-write) and ownership status
- **Correct Encryption Key** - Uses the credential owner's encryption key for decryption, not the viewing user's

#### Copy Password from List (ported from v1.02)
- **Copy Pwd Button** - Copy passwords to clipboard directly from the credentials list view via AJAX
- **`getPassword` Endpoint** - Secure on-demand password decryption endpoint with cross-user support
- **No Page Reload** - Uses fetch API for seamless clipboard copy without navigation

#### Group Assignment at Creation (ported from v1.02)
- **Group Selection on Create** - Assign credentials to groups at creation time with multi-select
- **Permission Level** - Choose read-only or read/write when assigning groups during creation
- **Immediate Sharing** - Groups are assigned right after credential creation in a single workflow

### Changed
- **Version Strings** - Updated all title bars and page titles from v1.00 to v2.00
- **Login Page** - Added link to Public PGP Key Directory
- **Router** - Added `keys` to public pages array; added `pgpkeys` and `keys` route cases
- **Directory Structure** - Added `data/pgpkeys/` for per-user PGP key files and `public_catalog.json.enc`

### New Files
- `src/Models/PGPKey.php` - PGP key store data model with catalog sync
- `src/Controllers/PGPKeyController.php` - Key Store CRUD + group sharing controller
- `src/Controllers/PublicKeyController.php` - Unauthenticated public directory controller
- `src/Views/pgpkeys/list.php` - Key Store list view
- `src/Views/pgpkeys/view.php` - Key Store detail view
- `src/Views/pgpkeys/create.php` - Import PGP key form with public listing checkbox
- `src/Views/pgpkeys/edit.php` - Edit PGP key form with public listing checkbox
- `src/Views/public/keys.php` - Self-contained public directory page with search and copy

---

## [1.00] - 2025-12-20

### Initial Release

PassGram v1.00 is a complete, production-ready password manager with group collaboration, PGP encryption, and OS/2 Warp 3.0 styling.

### Added

#### Core Features
- **Encrypted Password Storage** - AES-256-GCM encryption for all credentials
- **Group Collaboration** - Users belong to groups and can share credentials
- **PGP Key Management** - Generate and manage encryption keys
- **Invite-Only Registration** - Secure invite codes tied to specific groups
- **Notes System** - User notes (group-visible) and credential notes (private)
- **Multi-Field Credentials** - Store passwords, usernames, URLs, custom fields, tags
- **Password Generator** - Built-in secure random password generator

#### Group Management (Complete CRUD)
- Create new groups with name and description
- Edit existing groups (name, description)
- Delete groups (with confirmation, owner only)
- Add members to groups by username
- Remove members from groups (with confirmation)
- Transfer group ownership to another member
- View all group members with roles
- List all user's groups

#### Group-Level Credential Sharing
- Share credentials with entire groups (not just individuals)
- Permission levels:
  - **Read Only** - Members can view the credential
  - **Read & Write** - Members can view and edit the credential
- Revoke group access instantly
- View which groups have access to each credential
- Credentials list shows ownership status (Owner/Shared)
- Credentials list shows access level for shared items

#### PGP Encryption Options
- **Multiple Algorithms**:
  - RSA - 2048, 3072, or 4096 bits (recommended)
  - DSA - 2048, 3072, or 4096 bits (legacy)
  - Elliptic Curve - secp384r1, secp521r1, prime256v1 (modern)
- Dynamic form with algorithm selection
- Real-time security level display
- Algorithm and key size stored with user record
- PGP view page displays actual algorithm used
- Educational information about each algorithm

#### User Experience Enhancements
- **Copy-to-Clipboard Buttons** throughout application:
  - Invite codes (both code and full registration URL)
  - Credential usernames
  - Credential passwords
  - Credential URLs
  - PGP public keys
  - PGP fingerprints
- **Persistent Navigation Menu** - Dashboard menu accessible on all pages when logged in
- **Show/Hide Passwords** - Toggle password visibility in credential view
- **Dynamic Forms** - PGP generation form updates based on algorithm selection
- **Improved Layouts** - Flexbox layouts for better button placement

#### Security Infrastructure
- **Master Application Key (MAK)** - Encrypts all JSON database files with AES-256-GCM
- **User Master Password** - Never stored, only hashed (bcrypt for auth, Argon2id for key derivation)
- **Field-Level Encryption** - Sensitive credential fields encrypted individually
- **PGP Public Key Cryptography** - For secure credential sharing between users
- **CSRF Protection** - All state-changing operations protected with tokens
- **Session Security** - Secure, httponly, samesite=strict cookies with 60-minute timeout
- **Comprehensive Logging** - Audit trail of all security events and admin actions
- **Input Validation** - All user input validated and sanitized
- **XSS Prevention** - htmlspecialchars() used on all output

#### Core Infrastructure
- **Standalone PSR-4 Autoloader** - No Composer required
- **Config System** - Hierarchical configuration with environment support
- **Database Layer** - Encrypted JSON file operations with atomic writes
- **Session Management** - Secure PHP sessions with static helper class
- **Authentication System** - Password hashing, session management, user verification
- **Encryption Class** - AES-256-GCM with Argon2id key derivation
- **PGP Class** - Native PHP OpenSSL for RSA/DSA/EC operations
- **CSRF Protection** - Token generation and validation
- **Validator** - Email, username, password validation with error handling
- **Sanitizer** - XSS prevention and input cleaning
- **Logger** - File-based activity logging with levels

#### Data Models
- **User Model** - Create, read, update, delete users; password management; group membership; PGP key info
- **Group Model** - Full CRUD operations; member management; ownership transfer
- **Credential Model** - Full CRUD; group sharing; permission checking; accessible credentials
- **Invite Model** - Generate invite codes; validate; track usage
- **Share Model** - PGP-encrypted credential sharing between users
- **Note Model** - User notes and credential notes

#### Controllers
- **AuthController** - Login, registration, logout, session management
- **DashboardController** - Main dashboard with statistics and quick actions
- **CredentialController** - Full CRUD operations plus group sharing/revoking
- **GroupController** - Complete group management including transfer ownership
- **InviteController** - Generate and list invite codes
- **PGPController** - Generate keys with multiple algorithms, view keys
- **ShareController** - Share credentials with PGP encryption
- **NoteController** - Manage user and credential notes

#### Views (OS/2 Warp 3.0 Styled)
- **Layouts** - Header with persistent navigation, footer
- **Authentication** - Login, register pages with OS/2 styling
- **Dashboard** - Overview with quick stats and action buttons
- **Credentials** - List (with filtering), view, create, edit pages
- **Groups** - List, view (with member management), create, edit pages
- **Invites** - List with generation form and copy buttons
- **PGP** - Generate (with algorithm options), view (with copy/download)
- **Notes** - Forms for user and credential notes

#### User Interface
- **OS/2 Warp 3.0 Theme**:
  - Purple title bars (#5D009D)
  - Beveled borders (3D effect with outset/inset)
  - Classic gray backgrounds (#C0C0C0)
  - System fonts (monospace for code)
  - Classic button styles with :active states
  - Window-style containers
  - Traditional form controls
- **Responsive Design** - Works on desktop and mobile
- **JavaScript Enhancements**:
  - Copy-to-clipboard with notifications
  - Show/hide password functionality
  - Dynamic form updates (PGP generation)
  - Notification system (success/error messages)

#### Installation
- **install.php** - Interactive installation wizard with OS/2 styling
- Generates Master Application Key
- Creates first admin user
- Creates default group
- Generates first invite code
- Initializes encrypted database structure

#### Configuration
- **config/config.php** - Main application configuration
- **config/database.php** - Storage paths configuration
- **config/security.php** - Master key and crypto settings (generated by installer)
- **.htaccess** - Apache security headers and rewrite rules

#### Documentation
- **README.md** - Comprehensive documentation with installation, usage, security considerations
- **CHANGELOG.md** - This file, documenting all changes
- **Inline Comments** - PHP docblocks on all classes and methods

### Security Considerations

#### Encryption Layers
1. **Master Application Key** - All JSON files encrypted at rest
2. **User Master Password** - Derives keys for private PGP key encryption
3. **PGP Encryption** - For credential sharing between users
4. **Field-Level** - Sensitive credential fields encrypted individually

#### Password Security
- Authentication: bcrypt hash (cost factor 12)
- Key Derivation: Argon2id (memory: 65536 KB, time: 4, threads: 2)
- Never stored in plain text anywhere
- 12+ character minimum with complexity requirements

#### Data Storage
- All data in encrypted JSON files
- No SQL database required or used
- Atomic write operations with file locking
- Per-user credential files for scalability
- Proper file permissions (700 for data/, 600 for sensitive files)

### Technical Details

#### Requirements
- PHP 7.4+ (PHP 8.x recommended)
- OpenSSL extension (standard)
- JSON extension (standard)
- Writable data/ directory
- HTTPS (required for production)

#### No External Dependencies
- No Composer packages
- No npm packages
- Pure PHP implementation
- Native OpenSSL for cryptography
- Standalone autoloader included

#### File Structure
```
v3.0/
├── autoload.php
├── install.php
├── public/
│   ├── index.php
│   ├── login.php
│   ├── logout.php
│   ├── assets/
│   │   ├── css/style.css
│   │   └── js/app.js
│   └── .htaccess
├── src/
│   ├── Core/
│   ├── Security/
│   ├── Models/
│   ├── Controllers/
│   ├── Views/
│   └── Helpers/
├── data/
│   ├── users.json.enc
│   ├── groups.json.enc
│   ├── invites.json.enc
│   ├── credentials/
│   ├── shares/
│   ├── notes/
│   ├── pgp/
│   └── logs/
└── config/
    ├── config.php
    ├── database.php
    └── security.php
```

### Known Limitations

- **No Database** - Uses encrypted JSON files instead of SQL (intentional design choice)
- **Single Server** - Not designed for distributed/clustered deployments
- **File-Based Sessions** - PHP session files (can be configured for Redis/Memcached)
- **No Email** - Invite codes must be shared manually (no email sending)
- **No 2FA** - Two-factor authentication not yet implemented
- **No API** - Web interface only, no REST API

### Browser Compatibility

- Modern browsers (Chrome, Firefox, Safari, Edge)
- JavaScript optional but recommended for enhanced UX
- Copy-to-clipboard requires modern browser with Clipboard API or execCommand support

### Tested On

- PHP 7.4, 8.0, 8.1, 8.2
- Apache 2.4 with mod_rewrite
- Nginx with PHP-FPM
- Linux (Ubuntu, Debian, CentOS)

### License

PassGram v1.00 - Copyright 2025 Jason Page / Amfile.org

---

**PassGram v3.0** - Secure. Simple. Standalone.
