<?php
/**
 * Test what HTML is actually generated by plugin embed
 */

// Simulate environment
$page_uuid = 'test-uuid-123';
$instance_id = 'test-instance';

// Generate the HTML link like embed.php does
$link_html = '<a href="#" onclick="event.preventDefault(); openPluginAdmin(\'' . htmlspecialchars($page_uuid) . '\', \'plugin_PlayList\', \'' . htmlspecialchars($instance_id) . '\', \'PlayList\');" class="config-link">Configure Playlist</a>';

echo "<!DOCTYPE html>\n";
echo "<html>\n";
echo "<head><title>HTML Output Test</title></head>\n";
echo "<body style='padding: 40px; background: #008080;'>\n";
echo "<h1 style='color: white;'>Generated HTML Test</h1>\n\n";

echo "<div style='background: white; padding: 20px; margin: 20px 0;'>\n";
echo "<h2>Raw PHP Output:</h2>\n";
echo "<pre>" . htmlspecialchars($link_html) . "</pre>\n";
echo "</div>\n\n";

echo "<div style='background: white; padding: 20px; margin: 20px 0;'>\n";
echo "<h2>Rendered Link (click it):</h2>\n";
echo $link_html . "\n";
echo "</div>\n\n";

echo "<div id='status' style='background: white; padding: 20px; margin: 20px 0;'>\n";
echo "Status: Waiting for JavaScript...\n";
echo "</div>\n\n";

echo "<script src='/public/js/plugin-admin-modal.js'></script>\n";
echo "<script>\n";
echo "setTimeout(function() {\n";
echo "  const status = document.getElementById('status');\n";
echo "  if (typeof openPluginAdmin === 'function') {\n";
echo "    status.innerHTML = '✓ JavaScript loaded<br>✓ openPluginAdmin exists<br><strong>Click the link above to test</strong>';\n";
echo "    status.style.background = '#ccffcc';\n";
echo "  } else {\n";
echo "    status.innerHTML = '✗ JavaScript NOT loaded<br>✗ openPluginAdmin does NOT exist';\n";
echo "    status.style.background = '#ffcccc';\n";
echo "  }\n";
echo "}, 500);\n";
echo "</script>\n";

echo "</body>\n";
echo "</html>\n";
