<?php // templates/site-tree.php ?>

<div class="window">
    <div class="window-title-bar">
        <span class="title">Site Tree - Complete Folder Hierarchy</span>
    </div>
    <div class="window-content">
        <div class="page-body">
            <h1>Site Folder Hierarchy</h1>
            <p>This page displays the complete folder and page structure of the site.</p>

            <div style="font-family: monospace; font-size: 14px; line-height: 1.6;">
                <?php
                function display_tree($path = '', $prefix = '', $is_last = true) {
                    $contents = get_directory_contents($path);
                    $folders = $contents['folders'] ?? [];
                    $pages = $contents['pages'] ?? [];

                    $all_items = [];

                    // Add folders first
                    foreach ($folders as $folder) {
                        $all_items[] = [
                            'type' => 'folder',
                            'name' => $folder['name'],
                            'path' => $folder['path']
                        ];
                    }

                    // Add pages
                    foreach ($pages as $page) {
                        $all_items[] = [
                            'type' => 'page',
                            'name' => $page['name'],
                            'path' => $page['path'],
                            'title' => $page['title']
                        ];
                    }

                    $total_items = count($all_items);

                    foreach ($all_items as $index => $item) {
                        $is_last_item = ($index === $total_items - 1);
                        $connector = $is_last_item ? '└── ' : '├── ';
                        $extension = $is_last_item ? '    ' : '│   ';

                        if ($item['type'] === 'folder') {
                            echo $prefix . $connector;
                            echo '<strong><a href="/?path=' . htmlspecialchars($item['path']) . '">';
                            echo '📁 ' . htmlspecialchars($item['name']);
                            echo '</a></strong><br>';

                            // Recurse into folder
                            display_tree($item['path'], $prefix . $extension, $is_last_item);
                        } else {
                            echo $prefix . $connector;
                            echo '<a href="/page/' . htmlspecialchars($item['path']) . '">';
                            echo '📄 ' . htmlspecialchars($item['title']);
                            echo '</a><br>';
                        }
                    }
                }

                // Start from root
                echo '<strong><a href="/">📁 / (Root)</a></strong><br>';
                display_tree('', '', true);
                ?>
            </div>

            <br>
            <p><a href="/"><button>Return to Home</button></a></p>
        </div>
    </div>
</div>
