<?php // templates/search.php 
// $query and $results are passed from router
?>

<div class="window">
    <div class="window-title-bar">
        <span class="title">Search Results</span>
    </div>

    <div class="search-bar">
        <form action="/search" method="GET">
            <input type="text" name="q" placeholder="Search pages or #hashtag..."
                   value="<?php echo e($query); ?>" id="search-input">
            <button type="submit">Search</button>
        </form>
        <div id="hashtag-suggestions" style="display: none; position: absolute; background: white; border: 1px solid #000; max-height: 200px; overflow-y: auto; z-index: 1000;"></div>
    </div>

    <div class="window-content">
        <?php if (isset($hashtag) && $hashtag): ?>
            <h2>Pages tagged with #<?php echo e($hashtag); ?> (<?php echo count($results); ?>)</h2>
        <?php else: ?>
            <h2>Results for "<?php echo e($query); ?>" (<?php echo count($results); ?>)</h2>
        <?php endif; ?>
        
        <ul class="page-list">
            <?php if (empty($results)): ?>
                <li>No pages found matching your query.</li>
            <?php else: ?>
                <?php foreach ($results as $page): ?>
                    <li>
                        <a href="/page/<?php echo e($page['path']); ?>"><?php echo e($page['title']); ?></a>
                        <span class="meta">
                            Path: /<?php echo e($page['path']); ?><br>
                            <?php echo e($page['context']); ?>
                        </span>
                    </li>
                <?php endforeach; ?>
            <?php endif; ?>
        </ul>
    </div>
</div>
