<?php // templates/rss.php
// $config, $pages, $parser, $base_url are passed from the loader

// Send the XML declaration
echo '<?xml version="1.0" encoding="UTF-8" ?>';
?>
<rss version="2.0" xmlns:atom="http://www.w3.org/2005/Atom">
<channel>
    <title><?php echo e($config['site_title']); ?></title>
    <link><?php echo e($base_url); ?></link>
    <description><?php echo e($config['site_description']); ?></description>
    <language>en-us</language>
    <pubDate><?php echo date(DATE_RSS, time()); ?></pubDate>
    <lastBuildDate><?php echo date(DATE_RSS, (int)($pages[0]['current_revision_id'] ?? time())); ?></lastBuildDate>
    <atom:link href="<?php echo e($base_url); ?>/rss" rel="self" type="application/rss+xml" />

    <?php foreach ($pages as $page): ?>
        <?php
        // Load the actual content for the description
        $content = get_revision_content($page['path'], $page['current_revision_id']);
        // Parse markdown and strip tags for a clean description
        $html_content = $parser->text($content);
        $description = e(substr(strip_tags($html_content), 0, 300) . '...');
        ?>
        <item>
            <title><?php echo e($page['title']); ?></title>
            <link><?php echo e($base_url); ?>/page/<?php echo e($page['path']); ?></link>
            <guid isPermaLink="true"><?php echo e($base_url); ?>/page/<?php echo e($page['path']); ?></guid>
            <pubDate><?php echo date(DATE_RSS, (int)$page['current_revision_id']); ?></pubDate>
            <description><![CDATA[ <?php echo $description; ?> ]]></description>
        </item>
    <?php endforeach; ?>

</channel>
</rss>
