<?php // templates/profile.php 

// $profile_user and $pages are passed from the router

// Get the new data, with fallbacks for users who haven't set them
$username = e($profile_user['username']);
$tagline = $profile_user['tagline'] ?? 'No tagline set.';
$photo_url = $profile_user['photo_url'] ?? ''; // Empty by default
$bio = $profile_user['bio'] ?? 'No bio set.';

// Use site logo as fallback if no photo URL is set
if (empty($photo_url)) {
    $photo_url = $config['site_logo'] ?? '/public/uploads/logo.png';
}

// Parse the markup for bio and tagline
$parser = new Parsedown();
$allowed_tags = '<p><b><i><strong><em><ul><ol><li><br><a><code><table><thead><tbody><tr><th><td>';

$safe_tagline_html = strip_tags($parser->text($tagline), $allowed_tags);
$safe_bio_html = strip_tags($parser->text($bio), $allowed_tags);

// Check if this profile belongs to the logged-in user
$is_own_profile = (isset($_SESSION['user']) && $_SESSION['user'] === $profile_user['username']);
?>

<div class="window">
    <div class="window-title-bar">
        <span class="title">Profile: <?php echo $username; ?></span>
    </div>
    <div class="window-content">
        
        <?php // Show 'Edit Profile' button only on your own profile ?>
        <?php if ($is_own_profile): ?>
            <a href="/profile-edit" class="edit-button">Edit My Profile</a>
        <?php endif; ?>

        <div class="profile-header">
            <img src="<?php echo e($photo_url); ?>" alt="<?php echo $username; ?>'s photo" class="profile-photo">
            <h2 class="profile-username"><?php echo $username; ?></h2>
            <div class="profile-tagline">
                <?php echo $safe_tagline_html; ?>
            </div>
        </div>

        <hr>

        <h3>Bio</h3>
        <div class="profile-bio page-body">
            <?php echo $safe_bio_html; ?>
        </div>

        <hr>

        <h3>Pages by <?php echo $username; ?> (Original Author)</h3>
        <ul class="page-list">
            <?php if (empty($pages)): ?>
                <li>This user has not created any pages.</li>
            <?php else: ?>
                <?php foreach ($pages as $page): ?>
                    <li>
                        <a href="/page/<?php echo e($page['slug']); ?>"><?php echo e($page['title']); ?></a>
                        <span class="meta">
                            (Last edit: <?php echo date('Y-m-d H:i', $page['current_revision_id']); ?>)
                        </span>
                    </li>
                <?php endforeach; ?>
            <?php endif; ?>
        </ul>
    </div>
</div>
