<?php // templates/profile-edit.php

// $profile_user (the logged-in user) is passed from the router
$username = e($profile_user['username']);
$current_photo = $profile_user['photo_url'] ?? '';
?>
<div class="window">
    <div class="window-title-bar">
        <span class="title">Edit Profile: <?php echo $username; ?></span>
    </div>
    <div class="window-content">

        <form action="/profile-save" method="POST" enctype="multipart/form-data">

            <input type="hidden" name="csrf_token" value="<?php echo generate_csrf_token(); ?>">

            <div>
                <label for="tagline">Tagline (Markup allowed):</label><br>
                <input type="text" id="tagline" name="tagline"
                       value="<?php echo e($profile_user['tagline'] ?? ''); ?>"
                       style="width: 80%;">
            </div>

            <br>

            <div>
                <label>Current Photo:</label><br>
                <?php if ($current_photo): ?>
                    <img src="<?php echo e($current_photo); ?>" alt="Current Photo" class="profile-photo-preview">
                <?php else: ?>
                    <p>None set.</p>
                <?php endif; ?>
            </div>
            <br>
            <div>
                <label for="profile_photo">Upload New Photo (JPG, PNG, GIF - max 5MB):</label><br>
                <small>This will replace your current photo.</small><br>
                <input type="file" id="profile_photo" name="profile_photo"
                       accept="image/jpeg,image/png,image/gif">
            </div>

            <br>

            <div>
                <label for="bio">Bio (Basic Markup & HTML):</label><br>
                <textarea id="bio" name="bio" rows="10"><?php echo e($profile_user['bio'] ?? ''); ?></textarea>
            </div>

            <hr style="margin: 20px 0;">

            <?php // --- NEW PASSWORD FIELDS --- ?>
            <h3>Change Password (Optional)</h3>
            <p><small>Leave blank to keep your current password.</small></p>
            <div>
                <label for="new_password">New Password:</label><br>
                <input type="password" id="new_password" name="new_password" style="width: 80%;">
            </div>
            <br>
            <div>
                <label for="confirm_password">Confirm New Password:</label><br>
                <input type="password" id="confirm_password" name="confirm_password" style="width: 80%;">
            </div>
            <?php // --- END NEW PASSWORD FIELDS --- ?>


            <br>

            <div>
                <button type="submit">Save Profile</button>
                <a href="/profile/<?php echo $username; ?>" style="margin-left: 10px;">Cancel</a>
            </div>
        </form>
    </div>
</div>