<?php // templates/password-prompt.php

// $page, $path, $error_message are passed from the router
$token = $_GET['token'] ?? '';
?>
<div class="window">
    <div class="window-title-bar">
        <span class="title">🔒 Password Required</span>
    </div>
    <div class="window-content">

        <h2>This page is password protected</h2>
        <p>Please enter the password to view this private page.</p>

        <?php if (!empty($error_message)): ?>
        <div class="notice-box" style="background: #ffcccc; border-color: #cc0000;">
            <strong>❌ <?php echo e($error_message); ?></strong>
        </div>
        <br>
        <?php endif; ?>

        <form action="/verify-password" method="POST">
            <input type="hidden" name="csrf_token" value="<?php echo generate_csrf_token(); ?>">
            <input type="hidden" name="page_path" value="<?php echo e($path); ?>">
            <input type="hidden" name="token" value="<?php echo e($token); ?>">

            <div>
                <label for="password">Password:</label><br>
                <input type="password" id="password" name="password"
                       style="width: 60%;"
                       required
                       autofocus>
            </div>

            <br>

            <div>
                <button type="submit">Submit</button>
            </div>
        </form>

        <br>
        <p style="font-size: 0.9em; color: #666;">
            <strong>Page:</strong> <?php echo e($page['title'] ?? 'Unknown'); ?><br>
            If you don't have the password, please contact the page author.
        </p>
    </div>
</div>
