<?php
// templates/partials/header.php

// --- Dynamic OG Tag Logic ---

// 1. Build the base URL (e.g., "https://book.os-2.in")
$base_url = (isset($_SERVER['HTTPS']) ? "https" : "http") . "://" . ($_SERVER['HTTP_HOST'] ?? 'localhost');

// 2. Set Defaults
$og_title = $config['site_title'] ?? 'My Site'; // Use null coalescing for safety
$og_desc = $config['site_description'] ?? '';
$og_image_path = $config['site_logo'] ?? '/public/uploads/logo.png'; // Default image path
$og_url = $base_url . ($_SERVER['REQUEST_URI'] ?? '/');
$og_type = 'website';

// 3. Check for Profile Page
// $profile_user is passed by the router only on profile pages
if (!empty($profile_user)) {
    $og_title = e($profile_user['username']) . "'s Profile | " . e($config['site_title'] ?? 'My Site');
    if (!empty($profile_user['bio'])) {
        $og_desc = substr(strip_tags($profile_user['bio']), 0, 155) . '...';
    }
    if (!empty($profile_user['photo_url'])) {
        $og_image_path = $profile_user['photo_url'];
    }
    $og_type = 'profile';
}
// 4. Check for Content Page
// $page is passed by the router only on content pages
elseif (!empty($page)) {
    $og_title = e($page['title'] ?? 'Untitled Page') . ' | ' . e($config['site_title'] ?? 'My Site');
    if (!empty($content)) { // $content is also passed for pages
        $og_desc = substr(strip_tags($content), 0, 155) . '...';
    }
    if (!empty($page['feature_image'])) {
        $og_image_path = $page['feature_image'];
    }
    $og_type = 'article';
}

// 5. Build the final, absolute image URL
// Check if the path is already absolute (starts with http or //)
if (strpos((string)$og_image_path, 'http') === 0 || strpos((string)$og_image_path, '//') === 0) {
    $og_image_url = $og_image_path;
} else {
    // Otherwise, prepend the base URL
    $og_image_url = $base_url . $og_image_path;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e($og_title); ?></title>
    <meta name="description" content="<?php echo e($og_desc); ?>">

    <meta property="og:title" content="<?php echo e($og_title); ?>">
    <meta property="og:description" content="<?php echo e($og_desc); ?>">
    <meta property="og:image" content="<?php echo e($og_image_url); ?>">
    <meta property="og:url" content="<?php echo e($og_url); ?>">
    <meta property="og:type" content="<?php echo $og_type; ?>">
    <meta property="og:site_name" content="<?php echo e($config['site_title'] ?? 'My Site'); ?>">

    <link rel="stylesheet" href="/public/css/style.css">
    <link rel="stylesheet" href="/public/css/plugin-wrapper.css">
    <link rel="stylesheet" href="/public/css/plugin-admin-modal.css">

    <link rel="stylesheet" media="print" href="/public/css/print.css">

    <link rel="alternate" type="application/rss+xml" title="RSS Feed" href="/rss">

</head>
<body>

    <?php // --- Movable Launchpad --- ?>
    <div id="launchpad">
        <div id="launchpad-header">
            <h3><?php echo e($config['site_title'] ?? 'My Site'); ?></h3>
        </div>

        <div class="launchpad-divider"></div> <?php // Horizontal divider ?>

        <div class="launchpad-content">
            <a href="/" class="launchpad-button" title="Home">
                <img src="https://api.iconify.design/mdi:home.svg?color=%23000080" alt="Home">
            </a>

            <?php if (is_editor()): ?>
                <a href="/edit/new-page-in-root" class="launchpad-button" title="New Page">
                    <img src="https://api.iconify.design/mdi:file-plus.svg?color=%23000080" alt="New Page">
                </a>
            <?php endif; ?>

            <?php if (is_admin()): ?>
                <a href="/admin" class="launchpad-button" title="Admin Panel">
                    <img src="https://api.iconify.design/mdi:cogs.svg?color=%23000080" alt="Admin">
                </a>
            <?php endif; ?>

            <a href="javascript:void(0);" class="launchpad-button" title="Popular Tags" id="hashtag-cloud-btn" onclick="showHashtagCloudModal()">
                <img src="https://api.iconify.design/mdi:pound.svg?color=%23000080" alt="Tags">
            </a>

            <?php // === Vertical Divider === ?>
            <div class="launchpad-divider vertical-divider"></div>

            <?php if (isset($_SESSION['user'])): ?>
                <a href="/profile/<?php echo e($_SESSION['user']); ?>" class="launchpad-button" title="My Profile">
                    <img src="https://api.iconify.design/mdi:account.svg?color=%23000080" alt="Profile">
                </a>
                <a href="/logout" class="launchpad-button" title="Logout">
                    <img src="https://api.iconify.design/mdi:logout.svg?color=%23000080" alt="Logout">
                </a>
            <?php else: ?>
                <a href="/login" class="launchpad-button" title="Login">
                    <img src="https://api.iconify.design/mdi:login.svg?color=%23000080" alt="Login">
                </a>
            <?php endif; ?>

            <a href="/rss" class="launchpad-button" title="RSS Feed">
                <img src="https://api.iconify.design/mdi:rss.svg?color=%23000080" alt="RSS">
            </a>
        </div>
    </div>
    <?php // --- End Launchpad --- ?>

    <?php // --- Hashtag Cloud Modal --- ?>
    <div id="hashtag-cloud-modal" style="display: none; position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); z-index: 2000; max-width: 600px; max-height: 80vh; overflow-y: auto;">
        <div class="window">
            <div class="window-title-bar">
                <span class="title">Popular Tags (Top 100)</span>
                <button id="close-hashtag-modal" onclick="hideHashtagCloudModal()" style="float: right; background: #c0c0c0; border: 2px outset #fff; cursor: pointer; padding: 0 5px;">✕</button>
            </div>
            <div class="window-content" id="hashtag-cloud-content" style="padding: 15px;">
                Loading...
            </div>
        </div>
    </div>
    <div id="hashtag-cloud-overlay" onclick="hideHashtagCloudModal()" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.5); z-index: 1999;"></div>
    <?php // --- End Hashtag Cloud Modal --- ?>
