<?php // templates/login.php ?>

<div class="window" style="max-width: 400px; margin-top: 50px;">
    <div class="window-title-bar">
        <span class="title">Login</span>
    </div>
    <div class="window-content">
        
        <form action="/login" method="POST">

            <?php // Display an error message if login fails
            if (isset($error) && $error): ?>
                <div style="color: #900; border: 1px solid #900; background: #fee; padding: 10px; margin-bottom: 15px;">
                    <?php echo e($error); ?>
                </div>
            <?php endif; ?>

            <?php // Hidden redirect field
            if (isset($redirect) && !empty($redirect)): ?>
                <input type="hidden" name="redirect" value="<?php echo e($redirect); ?>">
            <?php endif; ?>

            <div>
                <label for="username">Username:</label><br>
                <input type="text" id="username" name="username" style="width: 90%;" required>
            </div>

            <br>

            <div>
                <label for="password">Password:</label><br>
                <input type="password" id="password" name="password" style="width: 90%;" required>
            </div>

            <br>

            <div>
                <input type="checkbox" id="remember_me" name="remember_me" value="1" checked>
                <label for="remember_me">Keep me logged in</label>
            </div>

            <br>

            <div>
                <button type="submit">Login</button>
            </div>
        </form>
        
    </div>
</div>
