<?php // templates/home.php ?>

<div class="window">
    <div class="window-title-bar">
        <span class="title"><?php echo e($config['site_title']); ?> - Home</span>
    </div>
    <div class="window-content">
        <h2>Latest Content</h2>
        
        <ul class="page-list">
            <?php foreach ($pages as $page): ?>
                <li>
                    <a href="/page/<?php echo e($page['slug']); ?>"><?php echo e($page['title']); ?></a>
                    <span class="meta">
                        by <a href="/profile/<?php echo e($page['author']); ?>"><?php echo e($page['author']); ?></a>
                        (Last edit: <?php echo date('Y-m-d H:i', $page['current_revision_id']); ?>
                        by <?php echo e($page['last_edited_by'] ?? $page['author']); ?>)
                    </span>
                </li>
            <?php endforeach; ?>
            
            <?php if (empty($pages)): ?>
                <p>No content has been created yet.</p>
                <?php if (is_editor()): ?>
                    <p><a href="/edit/new-page">Create the first page!</a></p>
                <?php endif; ?>
            <?php endif; ?>
        </ul>
    </div>
</div>
