<?php // templates/edit.php

// $page, $content, $current_path are passed from the router
$is_new_page = !$page;
?>
<div class="window">
    <div class="window-title-bar">
        <span class="title">
            <?php echo $is_new_page ? 'Create New Page' : 'Editing: ' . e($page['title']); ?>
        </span>
    </div>
    <div class="window-content">

        <!-- Flash Messages -->
        <?php if (isset($_SESSION['admin_message'])): ?>
        <div style="background: #e8f4e8; border: 2px solid #4CAF50; padding: 12px; margin-bottom: 15px; font-weight: bold;">
            ✓ <?php echo e($_SESSION['admin_message']); unset($_SESSION['admin_message']); ?>
        </div>
        <?php endif; ?>

        <?php if (isset($_SESSION['admin_error'])): ?>
        <div style="background: #fdecea; border: 2px solid #f44336; padding: 12px; margin-bottom: 15px; font-weight: bold;">
            ✗ <?php echo e($_SESSION['admin_error']); unset($_SESSION['admin_error']); ?>
        </div>
        <?php endif; ?>

        <form action="/save" method="POST" enctype="multipart/form-data">

            <input type="hidden" name="csrf_token" value="<?php echo generate_csrf_token(); ?>">
            <input type="hidden" name="path" value="<?php echo e($current_path); ?>">
            <?php if (!$is_new_page): ?>
            <input type="hidden" name="original_slug" value="<?php echo e($page['slug'] ?? ''); ?>">
            <input type="hidden" name="is_existing_page" value="1">
            <?php endif; ?>

            <div>
                <label for="title">Page Title:</label><br>
                <input type="text" id="title" name="title"
                       value="<?php echo e($page['title'] ?? 'New Page Title'); ?>"
                       style="width: 80%;" required>
            </div>
            <br>
            <div>
                <label for="slug">Filename (slug):</label>
                <?php if ($is_new_page): ?>
                    <small>Leave blank to auto-generate from title.</small>
                <?php else: ?>
                    <small>Cannot be changed after page creation.</small>
                <?php endif; ?>
                <br>
                <input type="text" id="slug" name="slug"
                       value="<?php echo e($page['slug'] ?? ''); ?>"
                       style="width: 80%;"
                       <?php echo $is_new_page ? '' : 'readonly'; ?>>
            </div>
            
            <br>
            
            <div>
                <label for="feature_image_url">Feature Image URL:</label><br>
                <input type="text" id="feature_image_url" name="feature_image_url" 
                       value="<?php echo e($page['feature_image'] ?? ''); ?>"
                       style="width: 80%;"
                       placeholder="e.g., /public/uploads/image.png or https://...">
            </div>
            <br>
            <div>
                <label for="feature_image_file">Or Upload New Image (JPG, PNG, GIF - max 5MB):</label><br>
                <input type="file" id="feature_image_file" name="feature_image_file" 
                       accept="image/jpeg,image/png,image/gif">
            </div>
            <br>
            
            <div id="content-section">
                <label for="content">Content (Basic Markup & HTML):</label><br>
                <textarea id="content" name="content" rows="20" style="min-height: 70vh;"><?php echo e($content); ?></textarea>
            </div>

            <br>

            <!-- === PRIVACY SETTINGS === -->
            <div>
                <label>
                    <input type="checkbox" id="is_private" name="is_private" value="1"
                           <?php echo (!empty($page['is_private'])) ? 'checked' : ''; ?>
                           onchange="togglePasswordField()">
                    Make this page private (only accessible via share link)
                </label>
            </div>

            <div id="password_field" style="margin-top: 10px; <?php echo empty($page['is_private']) ? 'display: none;' : ''; ?>">
                <label for="page_password">Optional Password Protection:</label><br>
                <input type="password" id="page_password" name="page_password"
                       style="width: 60%;"
                       placeholder="Leave blank for no password or to keep existing password">
                <br>
                <small>
                    <?php if (!$is_new_page && !empty($page['password_hash'])): ?>
                        ⚠️ Password is currently set. Enter a new password to change it, or leave blank to keep existing.
                    <?php else: ?>
                        Add an extra layer of security. Visitors will need both the share link AND password to access.
                    <?php endif; ?>
                </small>
                <?php if (!$is_new_page && !empty($page['password_hash'])): ?>
                <br>
                <label style="margin-top: 5px;">
                    <input type="checkbox" name="remove_password" value="1">
                    Remove password protection (uncheck to keep password)
                </label>
                <?php endif; ?>
            </div>

            <?php if (!$is_new_page && !empty($page['is_private']) && !empty($page['share_token'])): ?>
            <div style="margin-top: 10px; padding: 10px; background: #fff8c4; border: 1px solid #a4913a;">
                <strong>Private Share Link:</strong><br>
                <input type="text" readonly
                       id="share_link"
                       value="<?php
                           $base_url = (isset($_SERVER['HTTPS']) ? 'https' : 'http') . '://' . ($_SERVER['HTTP_HOST'] ?? 'localhost');
                           echo e($base_url . '/page/' . $page['path'] . '?token=' . $page['share_token']);
                       ?>"
                       style="width: 90%; margin-top: 5px;"
                       onclick="this.select(); document.execCommand('copy'); alert('Share link copied to clipboard!');">
                <br><small>Click the link to copy it. Only people with this link can view this private page.</small>
            </div>
            <?php endif; ?>

            <br>

            <div>
                <button type="submit">Save Changes</button>
                <a href="/?path=<?php echo e($current_path); ?>" style="margin-left: 10px;">Cancel</a>
            </div>

        </form>

        <script>
        function togglePasswordField() {
            var checkbox = document.getElementById('is_private');
            var passwordField = document.getElementById('password_field');
            if (checkbox.checked) {
                passwordField.style.display = 'block';
            } else {
                passwordField.style.display = 'none';
            }
        }

        // Auto-scroll to content section on page load
        window.addEventListener('load', function() {
            var contentSection = document.getElementById('content-section');
            if (contentSection) {
                contentSection.scrollIntoView({ behavior: 'smooth', block: 'start' });
            }
        });
        </script>

        <hr style="margin: 30px 0; border: 1px solid #808080;">

        <!-- === PLUGIN MANAGER === -->
            <div id="plugin-manager" style="margin: 20px 0; padding: 15px; background: #f0f0f0; border: 2px solid #808080;">
                <h3 style="margin-top: 0;">Plugin Manager</h3>
                <p>Insert plugins into your article using shortcodes:</p>

                <?php
                require_once __DIR__ . '/../app/core/plugins.php';
                $available_plugins = discover_plugins();

                if (empty($available_plugins)): ?>
                    <p><em>No plugins available. Add plugins to the root directory with "plugin_" prefix.</em></p>
                <?php else: ?>
                    <div class="plugin-selector" style="margin: 15px 0;">
                        <label for="plugin-select"><strong>Select Plugin:</strong></label><br>
                        <select id="plugin-select" onchange="updatePluginForm()" style="width: 300px; padding: 5px; margin-top: 5px;">
                            <option value="">-- Choose a plugin --</option>
                            <?php foreach ($available_plugins as $plugin): ?>
                                <option value="<?php echo e($plugin['id']); ?>">
                                    <?php echo e($plugin['manifest']['name'] ?? $plugin['id']); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div id="plugin-form" style="display: none; margin-top: 15px; padding: 15px; background: #ffffff; border: 1px solid #808080;">
                        <label for="instance-id"><strong>Instance ID:</strong></label><br>
                        <input type="text" id="instance-id" placeholder="e.g., quiz-intro" style="width: 300px; padding: 5px; margin: 5px 0;">
                        <br>
                        <small>Unique identifier for this plugin instance on this page (alphanumeric, hyphens, underscores only)</small>
                        <br><br>

                        <button type="button" onclick="insertPluginShortcode()" style="padding: 8px 16px; background: #c0c0c0; border: 2px outset #c0c0c0; cursor: pointer;">
                            Insert Shortcode
                        </button>
                    </div>

                    <hr style="margin: 15px 0;">

                    <h4>Existing Plugin Instances</h4>
                    <?php
                    // Parse content for existing shortcodes
                    $existing_instances = extract_shortcodes_from_content($content);
                    if (empty($existing_instances)): ?>
                        <p><em>No plugin instances found in this article.</em></p>
                    <?php else: ?>
                        <ul style="margin: 10px 0;">
                            <?php foreach ($existing_instances as $instance): ?>
                                <li style="margin: 5px 0;">
                                    <strong><?php echo e($instance['plugin']); ?></strong> -
                                    ID: <code style="background: #ffff99; padding: 2px 5px;"><?php echo e($instance['id']); ?></code>
                                    <?php if (!$is_new_page && isset($page['uuid'])): ?>
                                        <a href="#" onclick="event.preventDefault(); openPluginAdmin('<?php echo e($page['uuid']); ?>', '<?php echo e($instance['plugin']); ?>', '<?php echo e($instance['id']); ?>', '<?php echo e($instance['plugin']); ?>');" style="margin-left: 10px;">
                                            [Configure]
                                        </a>
                                    <?php endif; ?>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                    <?php endif; ?>

                    <script>
                    function updatePluginForm() {
                        const select = document.getElementById('plugin-select');
                        const form = document.getElementById('plugin-form');

                        if (select.value) {
                            form.style.display = 'block';
                        } else {
                            form.style.display = 'none';
                        }
                    }

                    function insertPluginShortcode() {
                        const pluginId = document.getElementById('plugin-select').value;
                        const instanceId = document.getElementById('instance-id').value;
                        const textarea = document.getElementById('content');

                        if (!pluginId || !instanceId) {
                            alert('Please select a plugin and provide an instance ID');
                            return;
                        }

                        // Validate instance ID format
                        if (!/^[a-z0-9_-]+$/i.test(instanceId)) {
                            alert('Instance ID can only contain letters, numbers, hyphens, and underscores');
                            return;
                        }

                        // Remove 'plugin_' prefix for shortcode
                        const shortPluginName = pluginId.replace('plugin_', '');
                        const shortcode = '[plugin:' + shortPluginName + ' id=' + instanceId + ']';

                        // Insert at cursor position
                        const cursorPos = textarea.selectionStart;
                        const textBefore = textarea.value.substring(0, cursorPos);
                        const textAfter = textarea.value.substring(cursorPos);

                        textarea.value = textBefore + '\n\n' + shortcode + '\n\n' + textAfter;

                        // Move cursor after inserted shortcode
                        const newCursorPos = cursorPos + shortcode.length + 4;
                        textarea.setSelectionRange(newCursorPos, newCursorPos);
                        textarea.focus();

                        // Reset form
                        document.getElementById('plugin-select').value = '';
                        document.getElementById('instance-id').value = '';
                        updatePluginForm();

                        alert('Shortcode inserted! Don\'t forget to save the page.');
                    }
                    </script>
                <?php endif; ?>
            </div>
            <!-- === END PLUGIN MANAGER === -->

            <!-- === HTML EMBED BROWSER === -->
            <div class="embed-browser-section" style="margin: 20px 0; padding: 15px; background: #f0f0f0; border: 2px solid #808080;">
                <h3 style="margin-top: 0; cursor: pointer; user-select: none;" onclick="toggleEmbedBrowser()">
                    <span id="embed-browser-toggle">▶</span> HTML Embed Browser
                    <small style="font-weight: normal; font-size: 12px; margin-left: 10px;">(<?php echo count(get_html_embeds()); ?> available)</small>
                </h3>

                <div id="embed-browser-content" style="display: none;">
                    <p>Click an embed to insert it at cursor position:</p>

                    <div class="embed-grid" style="display: grid; grid-template-columns: repeat(auto-fill, minmax(200px, 1fr)); gap: 15px; margin-top: 15px;">
                        <?php
                        $embeds = get_html_embeds();
                        if (empty($embeds)):
                        ?>
                            <p class="no-embeds" style="padding: 20px; text-align: center; color: #666; font-style: italic; grid-column: 1 / -1;">
                                No HTML embeds available. <?php if (is_admin()): ?>Upload embeds in the <a href="/admin">admin panel</a>.<?php else: ?>Ask an admin to upload HTML embeds.<?php endif; ?>
                            </p>
                        <?php else: ?>
                            <?php foreach ($embeds as $embed): ?>
                            <div class="embed-card" onclick="insertEmbedShortcode('<?php echo e($embed['filename']); ?>')" style="background: white; border: 2px solid #808080; cursor: pointer; overflow: hidden; transition: all 0.2s;">
                                <div class="embed-preview" style="width: 100%; height: 150px; overflow: hidden; background: white; position: relative;">
                                    <iframe
                                        src="/embeds/<?php echo e($embed['filename']); ?>"
                                        sandbox="allow-scripts allow-same-origin"
                                        scrolling="no"
                                        loading="lazy"
                                        style="width: 200%; height: 200%; border: none; transform: scale(0.5); transform-origin: 0 0; pointer-events: none;">
                                    </iframe>
                                </div>
                                <div class="embed-info" style="padding: 10px; background: #e0e0e0; border-top: 1px solid #808080; display: flex; flex-direction: column; gap: 5px;">
                                    <strong style="font-size: 13px; word-break: break-word;"><?php echo e(basename($embed['filename'])); ?></strong>
                                    <span class="embed-size" style="font-size: 11px; color: #666;"><?php echo format_bytes($embed['size']); ?></span>
                                </div>
                            </div>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </div>
                </div>

                <script>
                // Toggle HTML Embed Browser visibility
                function toggleEmbedBrowser() {
                    const content = document.getElementById('embed-browser-content');
                    const toggle = document.getElementById('embed-browser-toggle');

                    if (content.style.display === 'none') {
                        content.style.display = 'block';
                        toggle.textContent = '▼';
                    } else {
                        content.style.display = 'none';
                        toggle.textContent = '▶';
                    }
                }

                // Insert HTML embed shortcode at cursor position
                function insertEmbedShortcode(filename) {
                    const textarea = document.getElementById('content');
                    const shortcode = '[html:' + filename + ']';

                    // Get cursor position
                    const startPos = textarea.selectionStart;
                    const endPos = textarea.selectionEnd;

                    // Insert shortcode
                    textarea.value =
                        textarea.value.substring(0, startPos) +
                        '\n\n' + shortcode + '\n\n' +
                        textarea.value.substring(endPos);

                    // Move cursor after shortcode
                    textarea.selectionStart = textarea.selectionEnd = startPos + shortcode.length + 4;

                    // Focus textarea
                    textarea.focus();

                    // Visual feedback
                    alert('Inserted: ' + shortcode + '\\n\\nDon\'t forget to save!');
                }
                </script>
            </div>
            <!-- === END HTML EMBED BROWSER === -->

            <!-- === PHP EMBED BROWSER === -->
            <div class="php-embed-browser-section" style="margin: 20px 0; padding: 15px; background: #f0f0f0; border: 2px solid #808080;">
                <h3 style="margin-top: 0; cursor: pointer; user-select: none;" onclick="togglePhpEmbedBrowser()">
                    <span id="php-embed-browser-toggle">▶</span> PHP Embed Browser
                    <small style="font-weight: normal; font-size: 12px; margin-left: 10px;">(<?php echo count(get_php_embeds()); ?> available)</small>
                </h3>

                <div id="php-embed-browser-content" style="display: none;">
                    <p>Click an embed to insert it at cursor position. PHP embeds support interactive parameters.</p>

                    <div class="php-embed-grid" style="display: grid; grid-template-columns: repeat(auto-fill, minmax(250px, 1fr)); gap: 15px; margin-top: 15px;">
                        <?php
                        require_once __DIR__ . '/../app/core/plugins.php';
                        $php_embeds = get_php_embeds();
                        if (empty($php_embeds)):
                        ?>
                            <p class="no-embeds" style="padding: 20px; text-align: center; color: #666; font-style: italic; grid-column: 1 / -1;">
                                No PHP embeds available. <?php if (is_admin()): ?>Upload PHP embeds in the <a href="/admin">admin panel</a>.<?php else: ?>Ask an admin to upload PHP embeds.<?php endif; ?>
                            </p>
                        <?php else: ?>
                            <?php foreach ($php_embeds as $php_embed):
                                // Get metadata to show parameters
                                $metadata = get_php_embed_metadata($php_embed['filename']);
                                $param_count = count($metadata['parameters']);
                            ?>
                            <div class="php-embed-card" onclick="insertPhpEmbedShortcode('<?php echo e($php_embed['filename']); ?>')" style="background: white; border: 2px solid #999; cursor: pointer; overflow: hidden; transition: all 0.2s; box-shadow: 2px 2px 0 #666;">
                                <div class="php-embed-icon" style="width: 100%; height: 100px; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); display: flex; align-items: center; justify-content: center; color: white; font-size: 48px; font-weight: bold; font-family: monospace; position: relative;">
                                    &lt;?&gt;
                                    <?php if ($param_count > 0): ?>
                                    <div style="position: absolute; top: 5px; right: 5px; background: rgba(255,255,255,0.9); color: #333; font-size: 11px; padding: 3px 8px; border-radius: 12px; font-weight: normal;">
                                        <?php echo $param_count; ?> param<?php echo $param_count !== 1 ? 's' : ''; ?>
                                    </div>
                                    <?php endif; ?>
                                </div>
                                <div class="php-embed-info" style="padding: 10px; background: #e0e0e0; border-top: 1px solid #999; display: flex; flex-direction: column; gap: 5px;">
                                    <strong style="font-size: 13px; word-break: break-word; font-family: 'Courier New', monospace;"><?php echo e(basename($php_embed['filename'])); ?></strong>
                                    <span class="php-embed-size" style="font-size: 11px; color: #666;"><?php echo format_bytes($php_embed['size']); ?></span>
                                    <?php if ($param_count > 0): ?>
                                    <span class="php-embed-params" style="font-size: 10px; color: #0078d7; margin-top: 3px;">
                                        Interactive: <?php
                                        $param_names = array_keys($metadata['parameters']);
                                        echo implode(', ', array_slice($param_names, 0, 3));
                                        if ($param_count > 3) echo '...';
                                        ?>
                                    </span>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </div>

                    <div style="margin-top: 15px; padding: 10px; background: #e8f4f8; border-left: 4px solid #0078d7; font-size: 12px;">
                        <strong>Quick Tips:</strong>
                        <ul style="margin: 5px 0; padding-left: 20px;">
                            <li>Basic: <code>[php:filename.php]</code></li>
                            <li>With parameters: <code>[php:filename.php param=value]</code></li>
                            <li>Custom size: <code>[php:filename.php width=800 height=600]</code></li>
                            <li>Files are automatically scanned for security violations</li>
                        </ul>
                    </div>
                </div>

                <script>
                // Toggle PHP Embed Browser visibility
                function togglePhpEmbedBrowser() {
                    const content = document.getElementById('php-embed-browser-content');
                    const toggle = document.getElementById('php-embed-browser-toggle');

                    if (content.style.display === 'none') {
                        content.style.display = 'block';
                        toggle.textContent = '▼';
                    } else {
                        content.style.display = 'none';
                        toggle.textContent = '▶';
                    }
                }

                // Insert PHP embed shortcode at cursor position
                function insertPhpEmbedShortcode(filename) {
                    const textarea = document.getElementById('content');
                    const shortcode = '[php:' + filename + ']';

                    // Get cursor position
                    const startPos = textarea.selectionStart;
                    const endPos = textarea.selectionEnd;

                    // Insert shortcode
                    textarea.value =
                        textarea.value.substring(0, startPos) +
                        '\n\n' + shortcode + '\n\n' +
                        textarea.value.substring(endPos);

                    // Move cursor after shortcode
                    textarea.selectionStart = textarea.selectionEnd = startPos + shortcode.length + 4;

                    // Focus textarea
                    textarea.focus();

                    // Visual feedback
                    alert('Inserted: ' + shortcode + '\n\nYou can add parameters after the filename.\nExample: [php:' + filename + ' param=value]\n\nDon\'t forget to save!');
                }

                // Add hover effect to PHP embed cards
                document.addEventListener('DOMContentLoaded', function() {
                    const cards = document.querySelectorAll('.php-embed-card');
                    cards.forEach(card => {
                        card.addEventListener('mouseenter', function() {
                            this.style.transform = 'translateY(-2px)';
                            this.style.boxShadow = '3px 3px 0 #444';
                        });
                        card.addEventListener('mouseleave', function() {
                            this.style.transform = 'translateY(0)';
                            this.style.boxShadow = '2px 2px 0 #666';
                        });
                    });
                });
                </script>
            </div>
            <!-- === END PHP EMBED BROWSER === -->

            <!-- === IMAGE MANAGER === -->
            <?php if (!$is_new_page && isset($page['uuid'])): ?>
            <div class="image-manager-section" style="margin: 20px 0; padding: 15px; background: #f0f0f0; border: 2px solid #808080;">
                <h3 style="margin-top: 0; cursor: pointer; user-select: none;" onclick="toggleImageManager()">
                    <span id="image-manager-toggle">▶</span> Image Manager
                    <small style="font-weight: normal; font-size: 12px; margin-left: 10px;">(<?php echo count(load_page_images($page['uuid'])); ?> images)</small>
                </h3>

                <div id="image-manager-content" style="display: none;">
                    <p>Upload and manage images for this page. Click an image to insert markdown at cursor position.</p>

                    <!-- Flash Messages -->
                    <?php if (isset($_SESSION['admin_message'])): ?>
                    <div style="background: #e8f4e8; border: 1px solid #4CAF50; padding: 10px; margin-bottom: 10px;">
                        <?php echo e($_SESSION['admin_message']); unset($_SESSION['admin_message']); ?>
                    </div>
                    <?php endif; ?>

                    <?php if (isset($_SESSION['admin_error'])): ?>
                    <div style="background: #fdecea; border: 1px solid #f44336; padding: 10px; margin-bottom: 10px;">
                        <?php echo e($_SESSION['admin_error']); unset($_SESSION['admin_error']); ?>
                    </div>
                    <?php endif; ?>

                    <!-- Upload Form -->
                    <form action="/admin-action" method="POST" enctype="multipart/form-data" style="margin: 15px 0; padding: 15px; background: #ffffff; border: 1px solid #808080;">
                        <input type="hidden" name="csrf_token" value="<?php echo generate_csrf_token(); ?>">
                        <input type="hidden" name="action" value="upload_page_image">
                        <input type="hidden" name="page_uuid" value="<?php echo e($page['uuid']); ?>">
                        <input type="hidden" name="redirect_path" value="<?php echo e($page['path']); ?>">

                        <label for="page_image_file"><strong>Upload Image:</strong></label><br>
                        <input type="file" id="page_image_file" name="page_image_file"
                               accept="image/jpeg,image/png,image/gif" required
                               style="margin: 5px 0;">
                        <br>
                        <small>JPG, PNG, or GIF - Max 10MB (will be auto-resized to reasonable web size)</small>
                        <br><br>
                        <button type="submit" style="padding: 8px 16px; background: #c0c0c0; border: 2px outset #c0c0c0; cursor: pointer;">
                            Upload Image
                        </button>
                    </form>

                    <!-- Image Grid -->
                    <div class="image-grid" style="display: grid; grid-template-columns: repeat(auto-fill, minmax(200px, 1fr)); gap: 15px; margin-top: 15px;">
                        <?php
                        $page_images = load_page_images($page['uuid']);
                        if (empty($page_images)):
                        ?>
                            <p class="no-images" style="padding: 20px; text-align: center; color: #666; font-style: italic; grid-column: 1 / -1;">
                                No images uploaded yet. Use the form above to upload images.
                            </p>
                        <?php else: ?>
                            <?php foreach ($page_images as $img): ?>
                            <div class="image-card" style="background: white; border: 2px solid #808080; overflow: hidden; display: flex; flex-direction: column;">
                                <!-- Image Preview -->
                                <div class="image-preview"
                                     onclick="insertImageMarkdown('<?php echo e($img['id']); ?>', '<?php echo e($page['uuid']); ?>', '<?php echo e($img['filename']); ?>', '<?php echo e($img['description']); ?>')"
                                     style="width: 100%; height: 150px; overflow: hidden; background: #f0f0f0; cursor: pointer; position: relative; display: flex; align-items: center; justify-content: center;">
                                    <img src="/page-image/<?php echo e($page['uuid']); ?>/<?php echo e($img['filename']); ?>"
                                         alt="<?php echo e($img['description'] ?: $img['original_name']); ?>"
                                         style="max-width: 100%; max-height: 100%; object-fit: contain;"
                                         loading="lazy">
                                </div>

                                <!-- Image Info -->
                                <div class="image-info" style="padding: 10px; background: #e0e0e0; border-top: 1px solid #808080;">
                                    <div style="margin-bottom: 5px;">
                                        <strong style="font-size: 11px; word-break: break-word;" title="<?php echo e($img['original_name']); ?>">
                                            <?php
                                            $display_name = $img['original_name'];
                                            if (strlen($display_name) > 20) {
                                                $display_name = substr($display_name, 0, 17) . '...';
                                            }
                                            echo e($display_name);
                                            ?>
                                        </strong>
                                    </div>

                                    <div style="font-size: 10px; color: #666; margin-bottom: 8px;">
                                        <?php echo e($img['width']); ?> × <?php echo e($img['height']); ?> •
                                        <?php echo format_bytes($img['size']); ?>
                                    </div>

                                    <!-- Description (editable) -->
                                    <div style="margin-bottom: 8px;">
                                        <input type="text"
                                               id="desc_<?php echo e($img['id']); ?>"
                                               value="<?php echo e($img['description']); ?>"
                                               placeholder="Alt text / description"
                                               style="width: 100%; padding: 3px; font-size: 11px; box-sizing: border-box;"
                                               onchange="updateImageDescription('<?php echo e($img['id']); ?>', '<?php echo e($page['uuid']); ?>', '<?php echo e($page['path']); ?>')">
                                    </div>

                                    <!-- Action Buttons -->
                                    <div style="display: flex; gap: 5px; justify-content: space-between;">
                                        <button onclick="insertImageMarkdown('<?php echo e($img['id']); ?>', '<?php echo e($page['uuid']); ?>', '<?php echo e($img['filename']); ?>', '<?php echo e($img['description']); ?>')"
                                                style="flex: 1; padding: 5px; font-size: 10px; background: #c0c0c0; border: 2px outset #c0c0c0; cursor: pointer;"
                                                title="Insert markdown at cursor">
                                            Insert
                                        </button>
                                        <button onclick="deletePageImage('<?php echo e($img['id']); ?>', '<?php echo e($page['uuid']); ?>', '<?php echo e($page['path']); ?>')"
                                                style="flex: 1; padding: 5px; font-size: 10px; background: #c0c0c0; border: 2px outset #c0c0c0; cursor: pointer;"
                                                title="Delete this image">
                                            Delete
                                        </button>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </div>
                </div>

                <script>
                // Toggle Image Manager visibility
                function toggleImageManager() {
                    const content = document.getElementById('image-manager-content');
                    const toggle = document.getElementById('image-manager-toggle');

                    if (content.style.display === 'none') {
                        content.style.display = 'block';
                        toggle.textContent = '▼';
                    } else {
                        content.style.display = 'none';
                        toggle.textContent = '▶';
                    }
                }

                // Insert image markdown at cursor position
                function insertImageMarkdown(imageId, pageUuid, filename, description) {
                    const textarea = document.getElementById('content');

                    // Build image URL
                    const imageUrl = '/page-image/' + pageUuid + '/' + filename;

                    // Build markdown with description or filename
                    const altText = description || filename;
                    const markdown = '![' + altText + '](' + imageUrl + ')';

                    // Get cursor position
                    const startPos = textarea.selectionStart;
                    const endPos = textarea.selectionEnd;

                    // Insert markdown
                    textarea.value =
                        textarea.value.substring(0, startPos) +
                        '\n\n' + markdown + '\n\n' +
                        textarea.value.substring(endPos);

                    // Move cursor after markdown
                    textarea.selectionStart = textarea.selectionEnd = startPos + markdown.length + 4;

                    // Focus textarea
                    textarea.focus();

                    // Visual feedback
                    alert('Inserted: ' + markdown + '\n\nDon\'t forget to save!');
                }

                // Update image description
                function updateImageDescription(imageId, pageUuid, pagePath) {
                    const descInput = document.getElementById('desc_' + imageId);
                    const description = descInput.value;

                    // Create and submit form
                    const form = document.createElement('form');
                    form.method = 'POST';
                    form.action = '/admin-action';

                    // Add CSRF token
                    const csrfInput = document.createElement('input');
                    csrfInput.type = 'hidden';
                    csrfInput.name = 'csrf_token';
                    csrfInput.value = '<?php echo generate_csrf_token(); ?>';
                    form.appendChild(csrfInput);

                    // Add action
                    const actionInput = document.createElement('input');
                    actionInput.type = 'hidden';
                    actionInput.name = 'action';
                    actionInput.value = 'update_page_image';
                    form.appendChild(actionInput);

                    // Add page UUID
                    const uuidInput = document.createElement('input');
                    uuidInput.type = 'hidden';
                    uuidInput.name = 'page_uuid';
                    uuidInput.value = pageUuid;
                    form.appendChild(uuidInput);

                    // Add image ID
                    const idInput = document.createElement('input');
                    idInput.type = 'hidden';
                    idInput.name = 'image_id';
                    idInput.value = imageId;
                    form.appendChild(idInput);

                    // Add description
                    const descriptionInput = document.createElement('input');
                    descriptionInput.type = 'hidden';
                    descriptionInput.name = 'description';
                    descriptionInput.value = description;
                    form.appendChild(descriptionInput);

                    // Add redirect path
                    const redirectInput = document.createElement('input');
                    redirectInput.type = 'hidden';
                    redirectInput.name = 'redirect_path';
                    redirectInput.value = pagePath;
                    form.appendChild(redirectInput);

                    // Submit
                    document.body.appendChild(form);
                    form.submit();
                }

                // Delete page image
                function deletePageImage(imageId, pageUuid, pagePath) {
                    if (!confirm('Are you sure you want to delete this image? This cannot be undone.')) {
                        return;
                    }

                    // Create and submit form
                    const form = document.createElement('form');
                    form.method = 'POST';
                    form.action = '/admin-action';

                    // Add CSRF token
                    const csrfInput = document.createElement('input');
                    csrfInput.type = 'hidden';
                    csrfInput.name = 'csrf_token';
                    csrfInput.value = '<?php echo generate_csrf_token(); ?>';
                    form.appendChild(csrfInput);

                    // Add action
                    const actionInput = document.createElement('input');
                    actionInput.type = 'hidden';
                    actionInput.name = 'action';
                    actionInput.value = 'delete_page_image';
                    form.appendChild(actionInput);

                    // Add page UUID
                    const uuidInput = document.createElement('input');
                    uuidInput.type = 'hidden';
                    uuidInput.name = 'page_uuid';
                    uuidInput.value = pageUuid;
                    form.appendChild(uuidInput);

                    // Add image ID
                    const idInput = document.createElement('input');
                    idInput.type = 'hidden';
                    idInput.name = 'image_id';
                    idInput.value = imageId;
                    form.appendChild(idInput);

                    // Add redirect path
                    const redirectInput = document.createElement('input');
                    redirectInput.type = 'hidden';
                    redirectInput.name = 'redirect_path';
                    redirectInput.value = pagePath;
                    form.appendChild(redirectInput);

                    // Submit
                    document.body.appendChild(form);
                    form.submit();
                }
                </script>
            </div>
            <!-- === END IMAGE MANAGER === -->
            <?php else: ?>
            <!-- Image Manager only available after saving page -->
            <div class="image-manager-section" style="margin: 20px 0; padding: 15px; background: #f0f0f0; border: 2px solid #808080;">
                <h3 style="margin-top: 0;">Image Manager</h3>
                <p style="color: #666; font-style: italic;">
                    Save this page first to enable the image manager. Each page gets its own image collection.
                </p>
            </div>
            <?php endif; ?>
    </div>
</div>
