<?php // templates/browser.php
// $current_path and $contents are passed from the router

// --- Breadcrumb and "Up" Button Logic ---
$path_parts = array_filter(explode('/', $current_path));
$breadcrumbs = [];
$temp_path = '';
foreach ($path_parts as $part) {
    $temp_path .= $part;
    $breadcrumbs[$part] = $temp_path;
    $temp_path .= '/';
}
// Ensure parent path calculation is correct even for root
$parent_path = ($current_path === '') ? '' : dirname($current_path);
// dirname of a root-level item returns '.', normalize it to empty string for root link
if ($parent_path === '.') {
    $parent_path = '';
}
?>

<div class="window">
    <div class="window-title-bar">

        <a href="/?path=<?php echo $parent_path; ?>" class="title-button">
            <img src="https://api.iconify.design/mdi:arrow-up-bold-box.svg?color=%23ffffff" alt="Up">
        </a>

        <span class="title">
            <a href="/">/</a>
            <?php foreach ($breadcrumbs as $name => $path): ?>
                <a href="/?path=<?php echo $path; ?>"><?php echo e($name); ?></a> /
            <?php endforeach; ?>
        </span>
    </div>

    <div class="search-bar">
        <form action="/search" method="GET">
            <input type="text" name="q" placeholder="Search all pages..."
                   value="<?php echo e($_GET['q'] ?? ''); ?>">
            <button type="submit">Search</button>
        </form>
    </div>

    <div class="window-content browser-container">

        <?php foreach ($contents['folders'] as $folder): ?>
            <div class="browser-item">
                <a href="/?path=<?php echo e($folder['path']); ?>" class="icon-link">
                    <img src="https://api.iconify.design/mdi:folder.svg?color=%23800000" alt="Folder" class="browser-icon">
                    <span class="item-name"><?php echo e($folder['name']); ?></span>
                </a>
                <?php if (is_admin()): // Admin-only actions ?>
                    <div class="item-actions">
                        <a href="#" class="edit-button-small" onclick="moveItem('<?php echo e($folder['path']); ?>'); return false;" title="Move">M</a> <a href="#" class="edit-button-small" onclick="renameItem('<?php echo e($folder['path']); ?>', '<?php echo e($folder['name']); ?>'); return false;" title="Rename">R</a> <form action="/admin-action" method="POST" class="inline-form">
                            <input type="hidden" name="csrf_token" value="<?php echo generate_csrf_token(); ?>">
                            <input type="hidden" name="action" value="delete-item">
                            <input type="hidden" name="path" value="<?php echo e($current_path); ?>">
                            <input type="hidden" name="item_path" value="<?php echo e($folder['path']); ?>">
                            <button type="submit" class="delete-button-small" title="Delete"
                                    onclick="return confirm('Are you sure you want to delete this folder and ALL its contents?');">
                                D </button>
                        </form>
                    </div>
                <?php endif; ?>
            </div>
        <?php endforeach; ?>

        <?php foreach ($contents['pages'] as $page): ?>
            <?php
                // Check for feature image
                $page_data = get_page_data($page['path']);
                $icon_src = 'https://api.iconify.design/mdi:file-document.svg?color=%23000080';
                $alt_text = 'Page';
                if (!empty($page_data['feature_image'])) {
                    $icon_src = e($page_data['feature_image']);
                    $alt_text = 'Feature Image';
                }
            ?>
            <div class="browser-item">
                <a href="/page/<?php echo e($page['path']); ?>" class="icon-link">
                    <img src="<?php echo $icon_src; ?>" alt="<?php echo $alt_text; ?>" class="browser-icon <?php echo !empty($page_data['feature_image']) ? 'feature-image-icon' : ''; ?>">
                    <span class="item-name"><?php echo e($page['title']); ?></span>
                </a>
                <div class="item-actions">
                    <?php if (is_editor()): // Editor action ?>
                        <a href="/edit/<?php echo e($page['path']); ?>" class="edit-button-small" title="Edit">E</a> <?php endif; ?>
                    <?php if (is_admin()): // Admin-only actions ?>
                        <a href="#" class="edit-button-small" onclick="moveItem('<?php echo e($page['path']); ?>'); return false;" title="Move">M</a> <a href="#" class="edit-button-small" onclick="renameItem('<?php echo e($page['path']); ?>', '<?php echo e($page['name']); ?>'); return false;" title="Rename">R</a> <form action="/admin-action" method="POST" class="inline-form">
                            <input type="hidden" name="csrf_token" value="<?php echo generate_csrf_token(); ?>">
                            <input type="hidden" name="action" value="delete-item">
                            <input type="hidden" name="path" value="<?php echo e($current_path); ?>">
                            <input type="hidden" name="item_path" value="<?php echo e($page['path']); ?>">
                            <button type="submit" class="delete-button-small" title="Delete"
                                    onclick="return confirm('Are you sure you want to delete this page?');">
                                D </button>
                        </form>
                    <?php endif; ?>
                </div>
            </div>
        <?php endforeach; ?>

        <?php if (empty($contents['folders']) && empty($contents['pages'])): ?>
            <p style="text-align: center; width: 100%; padding-top: 20px;">This folder is empty.</p>
        <?php endif; ?>

    </div>

    <div class="admin-forms">
        <?php if (is_admin()): // Admin-only form ?>
            <form action="/admin-action" method="POST"> <input type="hidden" name="csrf_token" value="<?php echo generate_csrf_token(); ?>">
                 <input type="hidden" name="action" value="create-folder">
                 <input type="hidden" name="path" value="<?php echo e($current_path); ?>">
                 <input type="text" name="folder_name" placeholder="New Folder Name" required>
                 <button type="submit">Create Folder</button>
            </form>
        <?php endif; ?>
        <?php if (is_editor()): // Editor-allowed button ?>
            <a href="/edit/new-page-in-<?php echo e($current_path ? $current_path : 'root'); ?>"> <button>Create New Page Here</button>
            </a>
        <?php endif; ?>
    </div>
</div>

<?php if (is_admin()): ?>
    <form action="/admin-action" method="POST" id="rename-form" style="display: none;">
        <input type="hidden" name="csrf_token" value="<?php echo generate_csrf_token(); ?>">
        <input type="hidden" name="action" value="rename-item">
        <input type="hidden" name="path" value="<?php echo e($current_path); ?>">
        <input type="hidden" name="item_path" id="rename-item-path">
        <input type="hidden" name="new_name" id="rename-new-name">
    </form>

    <form action="/admin-action" method="POST" id="move-form" style="display: none;">
        <input type="hidden" name="csrf_token" value="<?php echo generate_csrf_token(); ?>">
        <input type="hidden" name="action" value="move-item">
        <input type="hidden" name="path" value="<?php echo e($current_path); ?>"> <input type="hidden" name="item_path" id="move-item-path">   <input type="hidden" name="target_path" id="move-target-path"> </form>

    <script>
        function renameItem(itemPath, oldName) {
            let newName = prompt("Enter the new name (slug) for this item:", oldName);
            // Check if user cancelled or entered empty string or same name
            if (newName && newName.trim() !== '' && newName !== oldName) {
                document.getElementById('rename-item-path').value = itemPath;
                document.getElementById('rename-new-name').value = newName;
                document.getElementById('rename-form').submit();
            } else if (newName !== null && newName.trim() === '') {
                 alert('Error: New name cannot be empty.');
            }
        }

        function moveItem(itemPath) {
            let targetPath = prompt("Enter the target folder path (e.g., 'folder/subfolder' or leave blank for root):", "");
            // Allow empty string for root, but not null (cancel)
            if (targetPath !== null) {
                 // Basic validation/sanitization (PHP side does more)
                 targetPath = targetPath.replace(/^\/+|\/+$/g, ''); // Trim slashes

                document.getElementById('move-item-path').value = itemPath;
                document.getElementById('move-target-path').value = targetPath;
                document.getElementById('move-form').submit();
            }
        }
    </script>
<?php endif; ?>
