<?php // templates/admin.php 
// $config, $all_users are passed from router
?>
<div class="window">
    <div class="window-title-bar">
        <span class="title">Admin Panel</span>
    </div>
    <div class="window-content">
        
        <h2>Site Settings</h2>
        <form action="/admin-action" method="POST">
            <input type="hidden" name="csrf_token" value="<?php echo generate_csrf_token(); ?>">
            <input type="hidden" name="action" value="save_settings">
            
            <div>
                <label for="site_title">Site Title:</label><br>
                <input type="text" id="site_title" name="site_title" value="<?php echo e($config['site_title']); ?>" style="width: 80%;">
            </div>
            <br>
            <div>
                <label for="site_description">Site Description (for OG tags):</label><br>
                <input type="text" id="site_description" name="site_description" value="<?php echo e($config['site_description']); ?>" style="width: 80%;">
            </div>
            <br>
            <div>
                <label for="footer_prefix">Footer Prefix (HTML allowed):</label><br>
                <input type="text" id="footer_prefix" name="footer_prefix" value="<?php echo e($config['footer_prefix']); ?>" style="width: 80%;">
            </div>
            <br>
            <button type="submit">Save Settings</button>
        </form>

        <hr>

        <h2>ChatGram System Settings</h2>
        <form action="/admin-action" method="POST">
            <input type="hidden" name="csrf_token" value="<?php echo generate_csrf_token(); ?>">
            <input type="hidden" name="action" value="chatgram_settings">

            <div>
                <label>
                    <input type="checkbox" name="chatgram_enabled"
                           <?php echo ($config['chatgram']['enabled'] ?? false) ? 'checked' : ''; ?>>
                    Enable ChatGram System-Wide
                </label>
            </div>
            <br>
            <div>
                <label for="default_access_mode">Default Access Mode:</label><br>
                <select id="default_access_mode" name="default_access_mode">
                    <option value="login_only" <?php echo ($config['chatgram']['default_access_mode'] ?? 'login_only') === 'login_only' ? 'selected' : ''; ?>>Login Only</option>
                    <option value="login_and_guest" <?php echo ($config['chatgram']['default_access_mode'] ?? '') === 'login_and_guest' ? 'selected' : ''; ?>>Login + Guest</option>
                </select>
            </div>
            <br>
            <div>
                <label for="retention_days">Message Retention (days):</label><br>
                <input type="number" id="retention_days" name="retention_days" value="<?php echo $config['chatgram']['message_retention_days'] ?? 30; ?>" min="1" max="365" style="width: 100px;">
            </div>
            <br>
            <div>
                <label for="rate_limit">Rate Limit (messages per minute):</label><br>
                <input type="number" id="rate_limit" name="rate_limit" value="<?php echo $config['chatgram']['rate_limit_messages_per_minute'] ?? 10; ?>" min="1" max="60" style="width: 100px;">
            </div>
            <br>
            <button type="submit">Save ChatGram Settings</button>
        </form>

        <hr>

        <h2>User Management</h2>
        
        <h3>Current Users</h3>
        <ul>
            <?php foreach ($all_users as $user): ?>
                <li>
                    <strong><?php echo e($user['username']); ?></strong> (<?php echo e($user['role']); ?>)
                    - Invited by: <?php echo e($user['invited_by']); ?>
                    
                    <?php if ($user['username'] !== 'admin'): // Don't allow deleting 'admin' ?>
                    <form action="/admin-action" method="POST" class="inline-form">
                        <input type="hidden" name="csrf_token" value="<?php echo generate_csrf_token(); ?>">
                        <input type="hidden" name="action" value="delete_user">
                        <input type="hidden" name_
"username" value="<?php echo e($user['username']); ?>">
                        <button type="submit" class="delete-button-small"
                                onclick="return confirm('Are you sure you want to delete this user?');">
                            Delete
                        </button>
                    </form>
                    <?php endif; ?>
                </li>
            <?php endforeach; ?>
        </ul>
        
        <h3>Invite New User</h3>
        <form action="/admin-action" method="POST">
            <input type="hidden" name="csrf_token" value="<?php echo generate_csrf_token(); ?>">
            <input type="hidden" name="action" value="add_user">
            
            <label for="username">Username:</label>
            <input type="text" id="username" name="username" required>
            
            <label for="password">Password:</label>
            <input type="password" id="password" name="password" required>
            
            <label for="role">Role:</label>
            <select id="role" name="role">
                <option value="editor" selected>Editor</option>
                <option value="admin">Admin</option>
            </select>
            
            <button type="submit">Add User</button>
        </form>
        
        <?php // --- Content Management Section has been removed --- ?>
        <?php // --- It is now part of the main browser interface --- ?>

        <hr style="margin: 40px 0; border: 1px solid #c0c0c0;">

        <!-- HTML Embed Management -->
        <h2>HTML Embed Management</h2>

        <?php if (isset($_SESSION['admin_message'])): ?>
            <div class="admin-message success">
                <?php echo e($_SESSION['admin_message']); unset($_SESSION['admin_message']); ?>
            </div>
        <?php endif; ?>

        <?php if (isset($_SESSION['admin_error'])): ?>
            <div class="admin-message error">
                <?php echo e($_SESSION['admin_error']); unset($_SESSION['admin_error']); ?>
            </div>
        <?php endif; ?>

        <!-- Upload Form -->
        <h3>Upload HTML Embed</h3>
        <form method="POST" action="/admin-action" enctype="multipart/form-data" class="admin-form">
            <input type="hidden" name="csrf_token" value="<?php echo generate_csrf_token(); ?>">
            <input type="hidden" name="action" value="upload_html_embed">

            <label for="html_file">HTML File:</label>
            <input type="file" id="html_file" name="html_file" accept=".html,.htm" required>
            <p class="help-text">Max size: 10MB. Only .html and .htm files allowed.</p>

            <button type="submit">Upload Embed</button>
        </form>

        <!-- Current Embeds List -->
        <h3>Current HTML Embeds</h3>
        <?php
        $embeds = get_html_embeds();
        if (empty($embeds)):
        ?>
            <p class="help-text">No HTML embeds uploaded yet.</p>
        <?php else: ?>
            <table class="embeds-table">
                <thead>
                    <tr>
                        <th>Filename</th>
                        <th>Size</th>
                        <th>Modified</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($embeds as $embed): ?>
                    <tr>
                        <td><code><?php echo e($embed['filename']); ?></code></td>
                        <td><?php echo format_bytes($embed['size']); ?></td>
                        <td><?php echo date('Y-m-d H:i', $embed['modified']); ?></td>
                        <td>
                            <form method="POST" action="/admin-action" style="display:inline;">
                                <input type="hidden" name="csrf_token" value="<?php echo generate_csrf_token(); ?>">
                                <input type="hidden" name="action" value="delete_html_embed">
                                <input type="hidden" name="filename" value="<?php echo e($embed['filename']); ?>">
                                <button type="submit" onclick="return confirm('Delete <?php echo e($embed['filename']); ?>? This cannot be undone.');" class="button-danger">Delete</button>
                            </form>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php endif; ?>

    </div>

    <!-- PHP Embed Management Section -->
    <div class="admin-section">
        <h2>PHP Embed Management</h2>
        <p class="help-text">Upload and manage PHP embed files for interactive visualizations. Files are automatically scanned for security violations.</p>

        <?php if (isset($_SESSION['admin_message'])): ?>
            <div class="admin-message success">
                <?php echo e($_SESSION['admin_message']); unset($_SESSION['admin_message']); ?>
            </div>
        <?php endif; ?>

        <?php if (isset($_SESSION['admin_error'])): ?>
            <div class="admin-message error">
                <?php echo e($_SESSION['admin_error']); unset($_SESSION['admin_error']); ?>
            </div>
        <?php endif; ?>

        <!-- Upload Form -->
        <h3>Upload PHP Embed</h3>
        <form method="POST" action="/admin-action" enctype="multipart/form-data" class="admin-form">
            <input type="hidden" name="csrf_token" value="<?php echo generate_csrf_token(); ?>">
            <input type="hidden" name="action" value="upload_php_embed">

            <label for="php_file">PHP File:</label>
            <input type="file" id="php_file" name="php_file" accept=".php" required>
            <p class="help-text">Max size: 5MB. Only .php files allowed. File will be scanned for forbidden functions before upload.</p>

            <div class="security-notice" style="background: #fff3cd; border-left: 4px solid #ffc107; padding: 10px; margin: 10px 0;">
                <strong>Security Notice:</strong> Uploaded files are automatically scanned and will be rejected if they contain:
                <ul style="margin: 5px 0; padding-left: 20px;">
                    <li>File operations (fopen, file_get_contents, etc.)</li>
                    <li>Shell commands (exec, system, etc.)</li>
                    <li>Database operations (mysqli, PDO, etc.)</li>
                    <li>Network operations (curl, fsockopen, etc.)</li>
                    <li>Code evaluation (eval, include, require, etc.)</li>
                </ul>
                See <code>/php_embeds/README.md</code> for complete list of forbidden functions.
            </div>

            <button type="submit">Upload PHP Embed</button>
        </form>

        <!-- Current Embeds List -->
        <h3>Current PHP Embeds</h3>
        <?php
        $php_embeds = get_php_embeds();
        if (empty($php_embeds)):
        ?>
            <p class="help-text">No PHP embeds uploaded yet.</p>
        <?php else: ?>
            <table class="embeds-table">
                <thead>
                    <tr>
                        <th>Filename</th>
                        <th>Size</th>
                        <th>Modified</th>
                        <th>Usage</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($php_embeds as $embed): ?>
                    <tr>
                        <td><code><?php echo e($embed['filename']); ?></code></td>
                        <td><?php echo format_bytes($embed['size']); ?></td>
                        <td><?php echo date('Y-m-d H:i', $embed['modified']); ?></td>
                        <td><code style="font-size: 11px;">[php:<?php echo e($embed['filename']); ?>]</code></td>
                        <td>
                            <form method="POST" action="/admin-action" style="display:inline;">
                                <input type="hidden" name="csrf_token" value="<?php echo generate_csrf_token(); ?>">
                                <input type="hidden" name="action" value="delete_php_embed">
                                <input type="hidden" name="filename" value="<?php echo e($embed['filename']); ?>">
                                <button type="submit" onclick="return confirm('Delete <?php echo e($embed['filename']); ?>? This cannot be undone.');" class="button-danger">Delete</button>
                            </form>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php endif; ?>

        <div style="background: #e8f4f8; border-left: 4px solid #0078d7; padding: 10px; margin-top: 20px;">
            <strong>Quick Reference:</strong>
            <ul style="margin: 5px 0; padding-left: 20px;">
                <li>Embed in page: <code>[php:filename.php]</code></li>
                <li>With parameters: <code>[php:filename.php param1=value1 param2=value2]</code></li>
                <li>Custom size: <code>[php:filename.php width=800 height=600]</code></li>
                <li>Documentation: <code>/php_embeds/README.md</code> and <code>/php_embeds/QUICK_START.md</code></li>
                <li>Example file: <code>/php_embeds/fractal_pattern2.php</code></li>
            </ul>
        </div>

    </div>
</div>
