<?php // templates/about.php ?>

<div class="window">
    <div class="window-title-bar">
        <span class="title">About BookGram</span>
    </div>
    <div class="window-content">
        <div class="page-body">
            <h1>BookGram Version 10.0</h1>

            <p><strong>BookGram</strong> is a lightweight, hierarchical content management system designed for simplicity and efficiency. Inspired by the classic IBM OS/2 Warp aesthetic, BookGram provides a familiar and intuitive interface for managing your content.</p>

            <h2>Key Features</h2>
            <ul>
                <li><strong>Hierarchical File Browser:</strong> Organize your content in nested folders for easy navigation and management</li>
                <li><strong>Markdown & HTML Support:</strong> Write content using simple markup or full HTML</li>
                <li><strong>Revision History:</strong> Track all changes to your pages with complete revision control</li>
                <li><strong>User Management:</strong> Multi-user support with role-based permissions (Admin, Editor, Viewer)</li>
                <li><strong>Private Pages:</strong> Create password-protected pages with secure share links</li>
                <li><strong>Full-Text Search:</strong> Quick search across all content with hashtag support</li>
                <li><strong>RSS Feed:</strong> Automatic RSS feed generation for your latest content</li>
                <li><strong>Mobile Responsive:</strong> Fully optimized interface for desktop and mobile devices</li>
                <li><strong>Feature Images:</strong> Add visual appeal with customizable feature images for pages</li>
                <li><strong>Profile System:</strong> User profiles with avatars, bios, and author pages</li>
                <li><strong>⭐ Plugin System (NEW v10.0):</strong> Embed interactive plugins directly into articles using shortcodes</li>
                <li><strong>Isolated Plugin Instances:</strong> Each article can have its own plugin configurations with separate data storage</li>
                <li><strong>Unified Authentication:</strong> BookGram credentials automatically work in plugin admin panels</li>
            </ul>

            <h2>Use Case Scenarios</h2>
            <ul>
                <li><strong>Personal Knowledge Base:</strong> Build your own wiki-style documentation repository</li>
                <li><strong>Team Documentation:</strong> Collaborate on internal documentation with version control</li>
                <li><strong>Project Management:</strong> Organize projects in folders with notes, plans, and resources</li>
                <li><strong>Content Website:</strong> Create a simple content-driven website or blog</li>
                <li><strong>Research Notes:</strong> Store and organize research materials with nested categorization</li>
                <li><strong>Educational Content:</strong> Develop course materials with embedded quizzes and interactive forms</li>
                <li><strong>Portfolio:</strong> Showcase your work with organized galleries and descriptions</li>
                <li><strong>⭐ Interactive Learning Platform:</strong> Embed quizzes, surveys, and discussion boards directly in articles</li>
                <li><strong>Community Engagement:</strong> Add forms, polls, and forums to your content pages</li>
                <li><strong>Online Courses:</strong> Combine content with QuizGram assessments and JoinGram registration forms</li>
            </ul>

            <h2>Technical Specifications</h2>
            <ul>
                <li><strong>Backend:</strong> PHP 7.4+</li>
                <li><strong>Storage:</strong> File-based (no database required)</li>
                <li><strong>Security:</strong> CSRF protection, password hashing, session management, auth tokens</li>
                <li><strong>Theme:</strong> IBM OS/2 Warp 3 inspired design</li>
                <li><strong>Architecture:</strong> Procedural PHP with shortcode parsing and plugin hooks</li>
                <li><strong>Plugin System:</strong> Instance-based with isolated data storage per article</li>
                <li><strong>Included Plugins:</strong> QuizGram (quizzes), JoinGram (forms), QuesChan (forums)</li>
                <li><strong>License:</strong> Copyright to respective users</li>
            </ul>

            <h2>What's New in Version 10.0</h2>
            <div style="background: #e6f3ff; border: 2px solid #0066cc; padding: 15px; margin: 15px 0;">
                <h3 style="margin-top: 0; color: #0066cc;">Plugin System</h3>
                <p><strong>The major enhancement in v10.0 is the comprehensive plugin integration system:</strong></p>
                <ul>
                    <li><strong>Shortcode Embedding:</strong> Insert plugins using simple syntax like <code>[plugin:quizgram id=my-quiz]</code></li>
                    <li><strong>Instance Isolation:</strong> Each article maintains separate plugin instances with isolated data</li>
                    <li><strong>Plugin Manager:</strong> Built-in UI in the article editor for easy plugin insertion and configuration</li>
                    <li><strong>Session Passthrough:</strong> Your BookGram admin credentials automatically authenticate in plugin admin panels</li>
                    <li><strong>CSS Override:</strong> Plugins inherit BookGram's OS/2 Warp theme for consistent styling</li>
                    <li><strong>Auto-Discovery:</strong> New plugins are automatically detected when added to the root directory</li>
                    <li><strong>Three Ready-to-Use Plugins:</strong>
                        <ul>
                            <li><strong>QuizGram:</strong> Create interactive quizzes with scoring and leaderboards</li>
                            <li><strong>JoinGram:</strong> Build custom forms and surveys for data collection</li>
                            <li><strong>QuesChan:</strong> Add discussion boards and threaded conversations</li>
                        </ul>
                    </li>
                </ul>
            </div>

            <h2>Contact & Sales</h2>
            <p>For sales inquiries, licensing, or custom development:</p>
            <p style="background: #fff8c4; border: 2px solid #a4913a; padding: 15px; margin: 15px 0;">
                <strong>Email:</strong> <a href="mailto:jsp@pagetelegram.com">jsp@pagetelegram.com</a><br>
                <strong>Version:</strong> 10.0 (v1000)<br>
                <strong>Released:</strong> <?php echo date('Y'); ?>
            </p>

            <p><a href="/"><button>Return to Home</button></a></p>
        </div>
    </div>
</div>
