<?php
// setup.php

// Stop if setup is already complete
if (file_exists('app/storage/users.json') || file_exists('app/storage/config.json')) {
    die('Error: Setup has already been run. Delete users.json and config.json to reset.');
}

$setup_complete = false;

if ($_SERVER['REQUEST_METHOD'] === 'POST' && !empty($_POST['password'])) {
    
    // 1. Get password and hash it
    $admin_user = 'admin';
    $admin_pass = $_POST['password'];
    
    // Use ARGON2ID if available, otherwise BCRYPT
    $hash = password_hash($admin_pass, PASSWORD_ARGON2ID);
    
    // 2. Create the admin user
    $users_data = [
        $admin_user => [
            'username' => $admin_user,
            'password_hash' => $hash,
            'role' => 'admin',
            'invited_by' => 'system'
        ]
    ];
    
    // 3. Create the initial site config
    $config_data = [
        'site_title' => 'My New Site',
        'site_description' => 'A description of my site.',
        'site_logo' => '/public/uploads/logo.png',
        'footer_prefix' => '<span>Site content by its respective authors.</span>'
    ];
    
    // 4. Save files
    // Ensure directories exist and are writable by the server
    if (!is_dir('app/storage')) { mkdir('app/storage', 0755, true); }
    
    file_put_contents('app/storage/users.json', json_encode($users_data, JSON_PRETTY_PRINT));
    file_put_contents('app/storage/config.json', json_encode($config_data, JSON_PRETTY_PRINT));
    
    $setup_complete = true;
    
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Initial Site Setup</title>
    </head>
<body>
    <div class="window">
        <?php if ($setup_complete): ?>
            <h2>Setup Complete!</h2>
            <p>Your admin account ('admin') has been created.</p>
            <p style="color: red; font-weight: bold;">
                SECURITY WARNING: DELETE THIS FILE (setup.php) FROM YOUR SERVER IMMEDIATELY!
            </p>
        <?php else: ?>
            <h2>Site Setup</h2>
            <p>Please create your initial administrator password.</p>
            <form method="POST" action="setup.php">
                <label for="password">Admin Password:</label>
                <input type="password" id="password" name="password" required>
                <button type="submit">Create Admin</button>
            </form>
        <?php endif; ?>
    </div>
</body>
</html>
