<?php
/**
 * TaskGram Setup
 * Initializes a new instance with config and data files
 */

// Authenticate with BookGram
if (isset($_GET['bga_token'])) {
    require_once dirname(__DIR__) . '/app/core/plugin_auth.php';
    $auth = bookgram_auth_check();

    if (!$auth || !bookgram_is_editor()) {
        die('Authentication required');
    }
}

$instance_path = $_ENV['BOOKGRAM_INSTANCE_PATH'] ?? null;
if (!$instance_path) {
    die('Instance path not available');
}

$data_dir = $instance_path . '/data/';

// Create directories
if (!is_dir($data_dir)) {
    mkdir($data_dir, 0755, true);
}

// Check if already set up
$config_file = $data_dir . 'config.json';
if (file_exists($config_file)) {
    $token = $_GET['bga_token'] ?? '';
    header('Location: admin/index.php?bga_token=' . urlencode($token));
    exit;
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $config = [
        'instance_id' => $_ENV['BOOKGRAM_INSTANCE_ID'] ?? 'unknown',
        'created_at' => date('Y-m-d H:i:s'),
        'created_by' => (function_exists('bookgram_get_username') ? bookgram_get_username() : 'system'),
        'title' => trim($_POST['title'] ?? 'Task List'),
        'description' => trim($_POST['description'] ?? '')
    ];

    // Create empty task files
    file_put_contents($data_dir . 'tasks.json', '[]', LOCK_EX);
    file_put_contents($data_dir . 'completed.json', '[]', LOCK_EX);
    file_put_contents($config_file, json_encode($config, JSON_PRETTY_PRINT), LOCK_EX);

    $token = $_GET['bga_token'] ?? '';
    header('Location: admin/index.php?bga_token=' . urlencode($token));
    exit;
}

// Render setup form
?>
<!DOCTYPE html>
<html>
<head>
    <title>TaskGram Setup</title>
    <link rel="stylesheet" href="/public/css/os2-theme.css">
    <style>
        body {
            background: #008080;
            padding: 40px;
            font-family: "MS Sans Serif", sans-serif;
        }
        .window {
            max-width: 700px;
            margin: 0 auto;
            background: #c0c0c0;
            border: 2px solid #fff;
            box-shadow: 2px 2px 0 #000;
        }
        .window-title-bar {
            background: linear-gradient(to right, #000080, #1084d0);
            color: #fff;
            padding: 3px 5px;
            font-weight: bold;
            font-size: 14px;
        }
        .window-content {
            padding: 20px;
        }
        input[type="text"], textarea {
            width: 100%;
            padding: 8px;
            margin: 5px 0 15px 0;
            border: 2px inset #808080;
            font-family: inherit;
            box-sizing: border-box;
        }
        button {
            padding: 6px 15px;
            background: #c0c0c0;
            border: 2px outset #808080;
            cursor: pointer;
            font-family: inherit;
        }
        button:active {
            border-style: inset;
        }
        .btn-primary {
            background: #000080;
            color: #ffffff;
        }
    </style>
</head>
<body>
    <div class="window">
        <div class="window-title-bar">
            <span class="title">TaskGram Setup</span>
        </div>
        <div class="window-content">
            <h2 style="margin-top: 0; color: #000080;">Initialize Task List</h2>
            <p>Configure your new task list instance.</p>
            <form method="POST">
                <label><strong>Title:</strong></label><br>
                <input type="text" name="title" value="My Task List" required>

                <label><strong>Description (optional):</strong></label><br>
                <textarea name="description" rows="3" placeholder="Brief description of this task list..."></textarea>

                <div style="margin-top: 20px;">
                    <button type="submit" class="btn-primary">Create Task List</button>
                </div>
            </form>
        </div>
    </div>
</body>
</html>
