# TaskGram Plugin

A todo list manager plugin for BookGram with due dates, completion tracking, search, and export capabilities.

## Features

✅ **Task Management**
- Add, edit, and delete tasks
- Mark tasks as completed
- Optional due date and time for tasks
- Task search functionality

✅ **Completion Pool**
- Completed tasks stored separately
- Restore completed tasks to active
- Delete individual completed tasks
- Clear all completed tasks at once

✅ **Due Date Management**
- Optional due dates with color coding:
  - 🔴 Red: Overdue tasks
  - 🟡 Yellow: Due today
  - 🔵 Blue: Future tasks
- Optional time specification

✅ **Export Features**
- Export active tasks as CSV
- Export completed tasks as CSV
- Export tasks with due dates as iCal calendar file

✅ **Search**
- Real-time search filtering
- Search both active and completed tasks
- Client-side filtering for instant results

## Installation

The plugin is automatically discovered by BookGram when placed in the root directory with the `plugin_` prefix.

## Usage

### Embedding in Pages

Use this shortcode to embed a task list instance in any page:

```
[plugin:taskgram id=my-tasks]
```

Replace `my-tasks` with any unique identifier for that instance. Each page can have multiple independent task list instances.

### Configuration

1. Click the **⚙ Configure** link in the task list header
2. Set the title and description
3. View statistics about your tasks
4. Manage completed tasks in bulk

### Adding Tasks

1. Enter task description in the text field
2. Optionally check "Set due date/time" to add a deadline
3. Click **Add Task**

### Managing Tasks

- **Complete**: Click the checkbox next to a task
- **Delete**: Click the Delete button to remove permanently
- **Search**: Type in the search bar to filter tasks

### Completion Pool

- Completed tasks appear in a collapsible section at the bottom
- **Restore**: Move a completed task back to active
- **Delete**: Remove a completed task permanently
- **Clear All**: Delete all completed tasks at once

### Exporting

Three export options are available:
1. **Active Tasks (CSV)**: Download all active tasks
2. **Completed Tasks (CSV)**: Download all completed tasks
3. **Due Dates (iCal)**: Download calendar file with tasks that have due dates

## File Structure

```
plugin_taskgram/
├── plugin.json          # Plugin manifest
├── index.php            # Entry point
├── setup.php            # Instance initialization
├── embed.php            # Main UI rendering
├── admin/
│   └── index.php       # Configuration panel
├── api/
│   ├── task.php        # CRUD operations
│   ├── export-csv.php  # CSV export
│   └── export-ical.php # iCal export
├── css/
│   └── style.css       # OS/2 Warp styling
└── js/
    └── taskgram.js     # Frontend JavaScript
```

## Data Storage

Instance data is stored at:
```
app/storage/plugin_instances/{page_uuid}/plugin_taskgram/{instance_id}/data/
```

Each instance contains:
- `config.json` - Instance configuration
- `tasks.json` - Active tasks
- `completed.json` - Completed tasks (completion pool)

## Security Features

- Input sanitization for all user data
- Task text limited to 500 characters
- Date/time format validation
- File locking to prevent race conditions
- Editor authentication required for admin panel
- XSS prevention with htmlspecialchars()

## API Endpoints

### `/plugin_taskgram/api/task.php`

Handles task operations via POST with `action` parameter:
- `create_task` - Add new task
- `delete_task` - Delete active task
- `complete_task` - Move task to completion pool
- `restore_task` - Restore completed task to active
- `delete_completed` - Delete from completion pool
- `clear_completion_pool` - Delete all completed tasks

### `/plugin_taskgram/api/export-csv.php`

Download tasks as CSV:
- `?instance_id=X&type=active` - Export active tasks
- `?instance_id=X&type=completed` - Export completed tasks

### `/plugin_taskgram/api/export-ical.php`

Download tasks with due dates as iCalendar:
- `?instance_id=X` - Export as .ics file

## Browser Compatibility

- Modern browsers with ES6 JavaScript support
- HTML5 date/time input fields
- CSS Grid for layout

## Version

1.0.0 - Initial release

## Author

BookGram Team
